/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lease.Releasables;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.BytesRefHash;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.DocValueFormat;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.BucketOrder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.InternalOrder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.terms.AbstractStringTermsAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.terms.BucketPriorityQueue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.SearchContext;

public class StringTermsAggregator
extends AbstractStringTermsAggregator {
    private final ValuesSource valuesSource;
    protected final BytesRefHash bucketOrds;
    private final IncludeExclude.StringFilter includeExclude;

    public StringTermsAggregator(String name, AggregatorFactories factories, ValuesSource valuesSource, BucketOrder order, DocValueFormat format, TermsAggregator.BucketCountThresholds bucketCountThresholds, IncludeExclude.StringFilter includeExclude, SearchContext context, Aggregator parent, Aggregator.SubAggCollectionMode collectionMode, boolean showTermDocCountError, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        super(name, factories, context, parent, order, format, bucketCountThresholds, collectionMode, showTermDocCountError, pipelineAggregators, metaData);
        this.valuesSource = valuesSource;
        this.includeExclude = includeExclude;
        this.bucketOrds = new BytesRefHash(1L, context.bigArrays());
    }

    @Override
    public boolean needsScores() {
        return this.valuesSource != null && this.valuesSource.needsScores() || super.needsScores();
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        final SortedBinaryDocValues values = this.valuesSource.bytesValues(ctx);
        return new LeafBucketCollectorBase(sub, values){
            final BytesRefBuilder previous;
            {
                super(sub2, values2);
                this.previous = new BytesRefBuilder();
            }

            @Override
            public void collect(int doc, long bucket) throws IOException {
                assert (bucket == 0L);
                if (values.advanceExact(doc)) {
                    int valuesCount = values.docValueCount();
                    this.previous.clear();
                    for (int i = 0; i < valuesCount; ++i) {
                        BytesRef bytes = values.nextValue();
                        if (StringTermsAggregator.this.includeExclude != null && !StringTermsAggregator.this.includeExclude.accept(bytes) || i > 0 && this.previous.get().equals(bytes)) continue;
                        long bucketOrdinal = StringTermsAggregator.this.bucketOrds.add(bytes);
                        if (bucketOrdinal < 0L) {
                            bucketOrdinal = -1L - bucketOrdinal;
                            StringTermsAggregator.this.collectExistingBucket(sub, doc, bucketOrdinal);
                        } else {
                            StringTermsAggregator.this.collectBucket(sub, doc, bucketOrdinal);
                        }
                        this.previous.copyBytes(bytes);
                    }
                }
            }
        };
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        StringTerms.Bucket bucket;
        int i;
        int i2;
        assert (owningBucketOrdinal == 0L);
        if (!(this.bucketCountThresholds.getMinDocCount() != 0L || InternalOrder.isCountDesc(this.order) && this.bucketOrds.size() >= (long)this.bucketCountThresholds.getRequiredSize())) {
            for (LeafReaderContext ctx : this.context.searcher().getTopReaderContext().leaves()) {
                SortedBinaryDocValues values = this.valuesSource.bytesValues(ctx);
                for (int docId = 0; docId < ctx.reader().maxDoc(); ++docId) {
                    if (!values.advanceExact(docId)) continue;
                    int valueCount = values.docValueCount();
                    for (i2 = 0; i2 < valueCount; ++i2) {
                        BytesRef term = values.nextValue();
                        if (this.includeExclude != null && !this.includeExclude.accept(term)) continue;
                        this.bucketOrds.add(term);
                    }
                }
            }
        }
        int size = (int)Math.min(this.bucketOrds.size(), (long)this.bucketCountThresholds.getShardSize());
        long otherDocCount = 0L;
        BucketPriorityQueue<MultiBucketsAggregation.Bucket> ordered = new BucketPriorityQueue<MultiBucketsAggregation.Bucket>(size, this.order.comparator(this));
        StringTerms.Bucket spare = null;
        i2 = 0;
        while ((long)i2 < this.bucketOrds.size()) {
            if (spare == null) {
                spare = new StringTerms.Bucket(new BytesRef(), 0L, null, this.showTermDocCountError, 0L, this.format);
            }
            this.bucketOrds.get(i2, spare.termBytes);
            spare.docCount = this.bucketDocCount(i2);
            otherDocCount += spare.docCount;
            spare.bucketOrd = i2;
            if (this.bucketCountThresholds.getShardMinDocCount() <= spare.docCount && (spare = ordered.insertWithOverflow(spare)) == null) {
                this.consumeBucketsAndMaybeBreak(1);
            }
            ++i2;
        }
        StringTerms.Bucket[] list = new StringTerms.Bucket[ordered.size()];
        long[] survivingBucketOrds = new long[ordered.size()];
        for (i = ordered.size() - 1; i >= 0; --i) {
            bucket = (StringTerms.Bucket)ordered.pop();
            survivingBucketOrds[i] = bucket.bucketOrd;
            list[i] = bucket;
            otherDocCount -= bucket.docCount;
        }
        this.runDeferredCollections(survivingBucketOrds);
        for (i = 0; i < list.length; ++i) {
            bucket = list[i];
            bucket.termBytes = BytesRef.deepCopyOf(bucket.termBytes);
            bucket.aggregations = this.bucketAggregations(bucket.bucketOrd);
            bucket.docCountError = 0L;
        }
        return new StringTerms(this.name, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), this.pipelineAggregators(), this.metaData(), this.format, this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocCount, Arrays.asList(list), 0L);
    }

    @Override
    public void doClose() {
        Releasables.close(this.bucketOrds);
    }
}

