/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.nested;

import com.carrotsearch.hppc.LongArrayList;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.ReaderUtil;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.join.BitSetProducer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BitSet;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.lucene.search.Queries;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.ObjectMapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.InternalAggregation;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.nested.InternalNested;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.SearchContext;

public class NestedAggregator
extends BucketsAggregator
implements SingleBucketAggregator {
    static final ParseField PATH_FIELD = new ParseField("path", new String[0]);
    private final BitSetProducer parentFilter;
    private final Query childFilter;
    private final boolean collectsFromSingleBucket;
    private BufferingNestedLeafBucketCollector bufferingNestedLeafBucketCollector;

    NestedAggregator(String name, AggregatorFactories factories, ObjectMapper parentObjectMapper, ObjectMapper childObjectMapper, SearchContext context, Aggregator parentAggregator, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData, boolean collectsFromSingleBucket) throws IOException {
        super(name, factories, context, parentAggregator, pipelineAggregators, metaData);
        Query parentFilter = parentObjectMapper != null ? parentObjectMapper.nestedTypeFilter() : Queries.newNonNestedFilter(context.mapperService().getIndexSettings().getIndexVersionCreated());
        this.parentFilter = context.bitsetFilterCache().getBitSetProducer(parentFilter);
        this.childFilter = childObjectMapper.nestedTypeFilter();
        this.collectsFromSingleBucket = collectsFromSingleBucket;
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        DocIdSetIterator childDocs;
        IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext(ctx);
        IndexSearcher searcher = new IndexSearcher(topLevelContext);
        searcher.setQueryCache(null);
        Weight weight = searcher.createNormalizedWeight(this.childFilter, false);
        Scorer childDocsScorer = weight.scorer(ctx);
        final BitSet parentDocs = this.parentFilter.getBitSet(ctx);
        DocIdSetIterator docIdSetIterator = childDocs = childDocsScorer != null ? childDocsScorer.iterator() : null;
        if (this.collectsFromSingleBucket) {
            return new LeafBucketCollectorBase(sub, null){

                @Override
                public void collect(int parentDoc, long bucket) throws IOException {
                    if (parentDoc == 0 || parentDocs == null || childDocs == null) {
                        return;
                    }
                    int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                    int childDocId = childDocs.docID();
                    if (childDocId <= prevParentDoc) {
                        childDocId = childDocs.advance(prevParentDoc + 1);
                    }
                    while (childDocId < parentDoc) {
                        NestedAggregator.this.collectBucket(sub, childDocId, bucket);
                        childDocId = childDocs.nextDoc();
                    }
                }
            };
        }
        this.bufferingNestedLeafBucketCollector = new BufferingNestedLeafBucketCollector(sub, parentDocs, childDocs);
        return this.bufferingNestedLeafBucketCollector;
    }

    @Override
    protected void preGetSubLeafCollectors() throws IOException {
        this.processBufferedDocs();
    }

    @Override
    protected void doPostCollection() throws IOException {
        this.processBufferedDocs();
    }

    private void processBufferedDocs() throws IOException {
        if (this.bufferingNestedLeafBucketCollector != null) {
            this.bufferingNestedLeafBucketCollector.processBufferedChildBuckets();
        }
    }

    @Override
    public InternalAggregation buildAggregation(long owningBucketOrdinal) throws IOException {
        return new InternalNested(this.name, this.bucketDocCount(owningBucketOrdinal), this.bucketAggregations(owningBucketOrdinal), this.pipelineAggregators(), this.metaData());
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalNested(this.name, 0L, this.buildEmptySubAggregations(), this.pipelineAggregators(), this.metaData());
    }

    private static class CachedScorer
    extends Scorer {
        int doc;
        float score;

        private CachedScorer() {
            super(null);
        }

        @Override
        public DocIdSetIterator iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final float score() {
            return this.score;
        }

        @Override
        public int docID() {
            return this.doc;
        }
    }

    class BufferingNestedLeafBucketCollector
    extends LeafBucketCollectorBase {
        final BitSet parentDocs;
        final LeafBucketCollector sub;
        final DocIdSetIterator childDocs;
        final LongArrayList bucketBuffer;
        Scorer scorer;
        int currentParentDoc;
        final CachedScorer cachedScorer;

        BufferingNestedLeafBucketCollector(LeafBucketCollector sub, BitSet parentDocs, DocIdSetIterator childDocs) {
            super(sub, null);
            this.bucketBuffer = new LongArrayList();
            this.currentParentDoc = -1;
            this.cachedScorer = new CachedScorer();
            this.sub = sub;
            this.parentDocs = parentDocs;
            this.childDocs = childDocs;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            super.setScorer(this.cachedScorer);
        }

        @Override
        public void collect(int parentDoc, long bucket) throws IOException {
            if (parentDoc == 0 || this.parentDocs == null || this.childDocs == null) {
                return;
            }
            if (this.currentParentDoc != parentDoc) {
                this.processBufferedChildBuckets();
                if (NestedAggregator.this.needsScores()) {
                    this.cachedScorer.score = this.scorer.score();
                }
                this.currentParentDoc = parentDoc;
            }
            this.bucketBuffer.add(bucket);
        }

        void processBufferedChildBuckets() throws IOException {
            if (this.bucketBuffer.isEmpty()) {
                return;
            }
            int prevParentDoc = this.parentDocs.prevSetBit(this.currentParentDoc - 1);
            int childDocId = this.childDocs.docID();
            if (childDocId <= prevParentDoc) {
                childDocId = this.childDocs.advance(prevParentDoc + 1);
            }
            while (childDocId < this.currentParentDoc) {
                this.cachedScorer.doc = childDocId;
                long[] buffer = this.bucketBuffer.buffer;
                int size = this.bucketBuffer.size();
                for (int i = 0; i < size; ++i) {
                    NestedAggregator.this.collectBucket(this.sub, childDocId, buffer[i]);
                }
                childDocId = this.childDocs.nextDoc();
            }
            this.bucketBuffer.clear();
        }
    }
}

