/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.geogrid;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.SortedNumericDocValues;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.geo.GeoHashUtils;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.geo.GeoPoint;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.geo.GeoUtils;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.AbstractSortingNumericDocValues;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.MultiGeoPointValues;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.BucketUtils;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.MultiBucketAggregationBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGridAggregatorFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.bucket.geogrid.GeoHashGridParams;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support.ValueType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support.ValuesSource;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.SearchContext;

public class GeoGridAggregationBuilder
extends ValuesSourceAggregationBuilder<ValuesSource.GeoPoint, GeoGridAggregationBuilder>
implements MultiBucketAggregationBuilder {
    public static final String NAME = "geohash_grid";
    public static final int DEFAULT_PRECISION = 5;
    public static final int DEFAULT_MAX_NUM_CELLS = 10000;
    private static final ObjectParser<GeoGridAggregationBuilder, Void> PARSER = new ObjectParser("geohash_grid");
    private int precision = 5;
    private int requiredSize = 10000;
    private int shardSize = -1;

    public static GeoGridAggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return PARSER.parse(parser, new GeoGridAggregationBuilder(aggregationName), null);
    }

    public GeoGridAggregationBuilder(String name) {
        super(name, ValuesSourceType.GEOPOINT, ValueType.GEOPOINT);
    }

    protected GeoGridAggregationBuilder(GeoGridAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.precision = clone.precision;
        this.requiredSize = clone.requiredSize;
        this.shardSize = clone.shardSize;
    }

    @Override
    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new GeoGridAggregationBuilder(this, factoriesBuilder, metaData);
    }

    public GeoGridAggregationBuilder(StreamInput in) throws IOException {
        super(in, ValuesSourceType.GEOPOINT, ValueType.GEOPOINT);
        this.precision = in.readVInt();
        this.requiredSize = in.readVInt();
        this.shardSize = in.readVInt();
    }

    @Override
    protected void innerWriteTo(StreamOutput out) throws IOException {
        out.writeVInt(this.precision);
        out.writeVInt(this.requiredSize);
        out.writeVInt(this.shardSize);
    }

    public GeoGridAggregationBuilder precision(int precision) {
        this.precision = GeoUtils.checkPrecisionRange(precision);
        return this;
    }

    public int precision() {
        return this.precision;
    }

    public GeoGridAggregationBuilder size(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("[size] must be greater than 0. Found [" + size + "] in [" + this.name + "]");
        }
        this.requiredSize = size;
        return this;
    }

    public int size() {
        return this.requiredSize;
    }

    public GeoGridAggregationBuilder shardSize(int shardSize) {
        if (shardSize <= 0) {
            throw new IllegalArgumentException("[shardSize] must be greater than 0. Found [" + shardSize + "] in [" + this.name + "]");
        }
        this.shardSize = shardSize;
        return this;
    }

    public int shardSize() {
        return this.shardSize;
    }

    @Override
    protected ValuesSourceAggregatorFactory<ValuesSource.GeoPoint, ?> innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource.GeoPoint> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        int shardSize = this.shardSize;
        int requiredSize = this.requiredSize;
        if (shardSize < 0) {
            shardSize = BucketUtils.suggestShardSideQueueSize(requiredSize);
        }
        if (requiredSize <= 0 || shardSize <= 0) {
            throw new ElasticsearchException("parameters [required_size] and [shard_size] must be >0 in geohash_grid aggregation [" + this.name + "].", new Object[0]);
        }
        if (shardSize < requiredSize) {
            shardSize = requiredSize;
        }
        return new GeoHashGridAggregatorFactory(this.name, config, this.precision, requiredSize, shardSize, context, parent, subFactoriesBuilder, this.metaData);
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(GeoHashGridParams.FIELD_PRECISION.getPreferredName(), this.precision);
        builder.field(GeoHashGridParams.FIELD_SIZE.getPreferredName(), this.requiredSize);
        if (this.shardSize > -1) {
            builder.field(GeoHashGridParams.FIELD_SHARD_SIZE.getPreferredName(), this.shardSize);
        }
        return builder;
    }

    @Override
    protected boolean innerEquals(Object obj) {
        GeoGridAggregationBuilder other = (GeoGridAggregationBuilder)obj;
        if (this.precision != other.precision) {
            return false;
        }
        if (this.requiredSize != other.requiredSize) {
            return false;
        }
        return this.shardSize == other.shardSize;
    }

    @Override
    protected int innerHashCode() {
        return Objects.hash(this.precision, this.requiredSize, this.shardSize);
    }

    @Override
    public String getType() {
        return NAME;
    }

    static {
        ValuesSourceParserHelper.declareGeoFields(PARSER, false, false);
        PARSER.declareField((parser, builder, context) -> builder.precision(GeoUtils.parsePrecision(parser)), GeoHashGridParams.FIELD_PRECISION, ObjectParser.ValueType.INT);
        PARSER.declareInt(GeoGridAggregationBuilder::size, GeoHashGridParams.FIELD_SIZE);
        PARSER.declareInt(GeoGridAggregationBuilder::shardSize, GeoHashGridParams.FIELD_SHARD_SIZE);
    }

    static class CellIdSource
    extends ValuesSource.Numeric {
        private final ValuesSource.GeoPoint valuesSource;
        private final int precision;

        CellIdSource(ValuesSource.GeoPoint valuesSource, int precision) {
            this.valuesSource = valuesSource;
            this.precision = precision;
        }

        public int precision() {
            return this.precision;
        }

        @Override
        public boolean isFloatingPoint() {
            return false;
        }

        @Override
        public SortedNumericDocValues longValues(LeafReaderContext ctx) {
            return new CellValues(this.valuesSource.geoPointValues(ctx), this.precision);
        }

        @Override
        public SortedNumericDoubleValues doubleValues(LeafReaderContext ctx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SortedBinaryDocValues bytesValues(LeafReaderContext ctx) {
            throw new UnsupportedOperationException();
        }
    }

    private static class CellValues
    extends AbstractSortingNumericDocValues {
        private MultiGeoPointValues geoValues;
        private int precision;

        protected CellValues(MultiGeoPointValues geoValues, int precision) {
            this.geoValues = geoValues;
            this.precision = precision;
        }

        @Override
        public boolean advanceExact(int docId) throws IOException {
            if (this.geoValues.advanceExact(docId)) {
                this.resize(this.geoValues.docValueCount());
                for (int i = 0; i < this.docValueCount(); ++i) {
                    GeoPoint target = this.geoValues.nextValue();
                    this.values[i] = GeoHashUtils.longEncode(target.getLon(), target.getLat(), this.precision);
                }
                this.sort();
                return true;
            }
            return false;
        }
    }
}

