/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.document;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.get.GetRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.get.GetResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.VersionType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestStatus;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.RestActions;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.RestToXContentListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public class RestGetAction
extends BaseRestHandler {
    public RestGetAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/{id}", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}/{type}/{id}", this);
    }

    @Override
    public String getName() {
        return "document_get_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] fields;
        GetRequest getRequest = new GetRequest(request.param("index"), request.param("type"), request.param("id"));
        getRequest.refresh(request.paramAsBoolean("refresh", getRequest.refresh()));
        getRequest.routing(request.param("routing"));
        getRequest.parent(request.param("parent"));
        getRequest.preference(request.param("preference"));
        getRequest.realtime(request.paramAsBoolean("realtime", getRequest.realtime()));
        if (request.param("fields") != null) {
            throw new IllegalArgumentException("the parameter [fields] is no longer supported, please use [stored_fields] to retrieve stored fields or [_source] to load the field from _source");
        }
        String fieldsParam = request.param("stored_fields");
        if (fieldsParam != null && (fields = Strings.splitStringByCommaToArray(fieldsParam)) != null) {
            getRequest.storedFields(fields);
        }
        getRequest.version(RestActions.parseVersion(request));
        getRequest.versionType(VersionType.fromString(request.param("version_type"), getRequest.versionType()));
        getRequest.fetchSourceContext(FetchSourceContext.parseFromRestRequest(request));
        return channel -> client.get(getRequest, (ActionListener<GetResponse>)new RestToXContentListener<GetResponse>(channel){

            @Override
            protected RestStatus getStatus(GetResponse response) {
                return response.isExists() ? RestStatus.OK : RestStatus.NOT_FOUND;
            }
        });
    }
}

