/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.cat;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.CollectionUtil;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.recovery.RecoveryRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.recovery.RecoveryResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.routing.RecoverySource;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Table;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.indices.recovery.RecoveryState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.RestResponseListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.cat.RestTable;

public class RestRecoveryAction
extends AbstractCatAction {
    public RestRecoveryAction(Settings settings, RestController restController) {
        super(settings);
        restController.registerHandler(RestRequest.Method.GET, "/_cat/recovery", this);
        restController.registerHandler(RestRequest.Method.GET, "/_cat/recovery/{index}", this);
    }

    @Override
    public String getName() {
        return "cat_recovery_action";
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/recovery\n");
        sb.append("/_cat/recovery/{index}\n");
    }

    @Override
    public BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        RecoveryRequest recoveryRequest = new RecoveryRequest(Strings.splitStringByCommaToArray(request.param("index")));
        recoveryRequest.detailed(request.paramAsBoolean("detailed", false));
        recoveryRequest.activeOnly(request.paramAsBoolean("active_only", false));
        recoveryRequest.indicesOptions(IndicesOptions.fromRequest(request, recoveryRequest.indicesOptions()));
        return channel -> client.admin().indices().recoveries(recoveryRequest, (ActionListener<RecoveryResponse>)new RestResponseListener<RecoveryResponse>(channel){

            @Override
            public RestResponse buildResponse(RecoveryResponse response) throws Exception {
                return RestTable.buildResponse(RestRecoveryAction.this.buildRecoveryTable(request, response), this.channel);
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table t = new Table();
        t.startHeaders().addCell("index", "alias:i,idx;desc:index name").addCell("shard", "alias:s,sh;desc:shard name").addCell("time", "alias:t,ti;desc:recovery time").addCell("type", "alias:ty;desc:recovery type").addCell("stage", "alias:st;desc:recovery stage").addCell("source_host", "alias:shost;desc:source host").addCell("source_node", "alias:snode;desc:source node name").addCell("target_host", "alias:thost;desc:target host").addCell("target_node", "alias:tnode;desc:target node name").addCell("repository", "alias:rep;desc:repository").addCell("snapshot", "alias:snap;desc:snapshot").addCell("files", "alias:f;desc:number of files to recover").addCell("files_recovered", "alias:fr;desc:files recovered").addCell("files_percent", "alias:fp;desc:percent of files recovered").addCell("files_total", "alias:tf;desc:total number of files").addCell("bytes", "alias:b;desc:number of bytes to recover").addCell("bytes_recovered", "alias:br;desc:bytes recovered").addCell("bytes_percent", "alias:bp;desc:percent of bytes recovered").addCell("bytes_total", "alias:tb;desc:total number of bytes").addCell("translog_ops", "alias:to;desc:number of translog ops to recover").addCell("translog_ops_recovered", "alias:tor;desc:translog ops recovered").addCell("translog_ops_percent", "alias:top;desc:percent of translog ops recovered").endHeaders();
        return t;
    }

    public Table buildRecoveryTable(RestRequest request, RecoveryResponse response) {
        Table t = this.getTableWithHeader(request);
        for (String index : response.shardRecoveryStates().keySet()) {
            List<RecoveryState> shardRecoveryStates = response.shardRecoveryStates().get(index);
            if (shardRecoveryStates.size() == 0) continue;
            CollectionUtil.introSort(shardRecoveryStates, new Comparator<RecoveryState>(){

                @Override
                public int compare(RecoveryState o1, RecoveryState o2) {
                    int id2;
                    int id1 = o1.getShardId().id();
                    if (id1 < (id2 = o2.getShardId().id())) {
                        return -1;
                    }
                    if (id1 > id2) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (RecoveryState state : shardRecoveryStates) {
                t.startRow();
                t.addCell(index);
                t.addCell(state.getShardId().id());
                t.addCell(new TimeValue(state.getTimer().time()));
                t.addCell(state.getRecoverySource().getType().toString().toLowerCase(Locale.ROOT));
                t.addCell(state.getStage().toString().toLowerCase(Locale.ROOT));
                t.addCell(state.getSourceNode() == null ? "n/a" : state.getSourceNode().getHostName());
                t.addCell(state.getSourceNode() == null ? "n/a" : state.getSourceNode().getName());
                t.addCell(state.getTargetNode().getHostName());
                t.addCell(state.getTargetNode().getName());
                t.addCell(state.getRecoverySource() == null || state.getRecoverySource().getType() != RecoverySource.Type.SNAPSHOT ? "n/a" : ((RecoverySource.SnapshotRecoverySource)state.getRecoverySource()).snapshot().getRepository());
                t.addCell(state.getRecoverySource() == null || state.getRecoverySource().getType() != RecoverySource.Type.SNAPSHOT ? "n/a" : ((RecoverySource.SnapshotRecoverySource)state.getRecoverySource()).snapshot().getSnapshotId().getName());
                t.addCell(state.getIndex().totalRecoverFiles());
                t.addCell(state.getIndex().recoveredFileCount());
                t.addCell(String.format(Locale.ROOT, "%1.1f%%", Float.valueOf(state.getIndex().recoveredFilesPercent())));
                t.addCell(state.getIndex().totalFileCount());
                t.addCell(state.getIndex().totalRecoverBytes());
                t.addCell(state.getIndex().recoveredBytes());
                t.addCell(String.format(Locale.ROOT, "%1.1f%%", Float.valueOf(state.getIndex().recoveredBytesPercent())));
                t.addCell(state.getIndex().totalBytes());
                t.addCell(state.getTranslog().totalOperations());
                t.addCell(state.getTranslog().recoveredOperations());
                t.addCell(String.format(Locale.ROOT, "%1.1f%%", Float.valueOf(state.getTranslog().recoveredPercent())));
                t.endRow();
            }
        }
        return t;
    }
}

