/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ingest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.collect.Tuple;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ingest.IngestDocument;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ingest.IngestMetric;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ingest.Processor;

public class CompoundProcessor
implements Processor {
    public static final String ON_FAILURE_MESSAGE_FIELD = "on_failure_message";
    public static final String ON_FAILURE_PROCESSOR_TYPE_FIELD = "on_failure_processor_type";
    public static final String ON_FAILURE_PROCESSOR_TAG_FIELD = "on_failure_processor_tag";
    private final boolean ignoreFailure;
    private final List<Processor> processors;
    private final List<Processor> onFailureProcessors;
    private final List<Tuple<Processor, IngestMetric>> processorsWithMetrics;
    private final LongSupplier relativeTimeProvider;

    CompoundProcessor(LongSupplier relativeTimeProvider, Processor ... processor) {
        this(false, Arrays.asList(processor), Collections.emptyList(), relativeTimeProvider);
    }

    public CompoundProcessor(Processor ... processor) {
        this(false, Arrays.asList(processor), Collections.emptyList());
    }

    public CompoundProcessor(boolean ignoreFailure, List<Processor> processors, List<Processor> onFailureProcessors) {
        this(ignoreFailure, processors, onFailureProcessors, System::nanoTime);
    }

    CompoundProcessor(boolean ignoreFailure, List<Processor> processors, List<Processor> onFailureProcessors, LongSupplier relativeTimeProvider) {
        this.ignoreFailure = ignoreFailure;
        this.processors = processors;
        this.onFailureProcessors = onFailureProcessors;
        this.relativeTimeProvider = relativeTimeProvider;
        this.processorsWithMetrics = new ArrayList<Tuple<Processor, IngestMetric>>(processors.size());
        processors.forEach(p -> this.processorsWithMetrics.add(new Tuple<Processor, IngestMetric>((Processor)p, new IngestMetric())));
    }

    List<Tuple<Processor, IngestMetric>> getProcessorsWithMetrics() {
        return this.processorsWithMetrics;
    }

    public boolean isIgnoreFailure() {
        return this.ignoreFailure;
    }

    public List<Processor> getOnFailureProcessors() {
        return this.onFailureProcessors;
    }

    public List<Processor> getProcessors() {
        return this.processors;
    }

    public List<Processor> flattenProcessors() {
        ArrayList<Processor> allProcessors = new ArrayList<Processor>(CompoundProcessor.flattenProcessors(this.processors));
        allProcessors.addAll(CompoundProcessor.flattenProcessors(this.onFailureProcessors));
        return allProcessors;
    }

    private static List<Processor> flattenProcessors(List<Processor> processors) {
        ArrayList<Processor> flattened = new ArrayList<Processor>();
        for (Processor processor : processors) {
            if (processor instanceof CompoundProcessor) {
                flattened.addAll(((CompoundProcessor)processor).flattenProcessors());
                continue;
            }
            flattened.add(processor);
        }
        return flattened;
    }

    @Override
    public String getType() {
        return "compound";
    }

    @Override
    public String getTag() {
        return "CompoundProcessor-" + this.flattenProcessors().stream().map(Processor::getTag).collect(Collectors.joining("-"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IngestDocument execute(IngestDocument ingestDocument) throws Exception {
        for (Tuple<Processor, IngestMetric> processorWithMetric : this.processorsWithMetrics) {
            Processor processor = processorWithMetric.v1();
            IngestMetric metric = processorWithMetric.v2();
            long startTimeInNanos = this.relativeTimeProvider.getAsLong();
            try {
                metric.preIngest();
                if (processor.execute(ingestDocument) != null) continue;
                IngestDocument ingestDocument2 = null;
                return ingestDocument2;
            }
            catch (Exception e) {
                metric.ingestFailed();
                if (this.ignoreFailure) continue;
                ElasticsearchException compoundProcessorException = this.newCompoundProcessorException(e, processor.getType(), processor.getTag());
                if (this.onFailureProcessors.isEmpty()) {
                    throw compoundProcessorException;
                }
                if (this.executeOnFailure(ingestDocument, compoundProcessorException)) break;
                IngestDocument ingestDocument3 = null;
                return ingestDocument3;
            }
            finally {
                long ingestTimeInMillis = TimeUnit.NANOSECONDS.toMillis(this.relativeTimeProvider.getAsLong() - startTimeInNanos);
                metric.postIngest(ingestTimeInMillis);
            }
        }
        return ingestDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean executeOnFailure(IngestDocument ingestDocument, ElasticsearchException exception) throws Exception {
        try {
            this.putFailureMetadata(ingestDocument, exception);
            for (Processor processor : this.onFailureProcessors) {
                try {
                    if (processor.execute(ingestDocument) != null) continue;
                    boolean bl = false;
                    return bl;
                }
                catch (Exception e) {
                    throw this.newCompoundProcessorException(e, processor.getType(), processor.getTag());
                    return true;
                }
            }
        }
        finally {
            this.removeFailureMetadata(ingestDocument);
        }
    }

    private void putFailureMetadata(IngestDocument ingestDocument, ElasticsearchException cause) {
        List<String> processorTypeHeader = cause.getHeader("processor_type");
        List<String> processorTagHeader = cause.getHeader("processor_tag");
        String failedProcessorType = processorTypeHeader != null ? processorTypeHeader.get(0) : null;
        String failedProcessorTag = processorTagHeader != null ? processorTagHeader.get(0) : null;
        Map<String, Object> ingestMetadata = ingestDocument.getIngestMetadata();
        ingestMetadata.put(ON_FAILURE_MESSAGE_FIELD, cause.getRootCause().getMessage());
        ingestMetadata.put(ON_FAILURE_PROCESSOR_TYPE_FIELD, failedProcessorType);
        ingestMetadata.put(ON_FAILURE_PROCESSOR_TAG_FIELD, failedProcessorTag);
    }

    private void removeFailureMetadata(IngestDocument ingestDocument) {
        Map<String, Object> ingestMetadata = ingestDocument.getIngestMetadata();
        ingestMetadata.remove(ON_FAILURE_MESSAGE_FIELD);
        ingestMetadata.remove(ON_FAILURE_PROCESSOR_TYPE_FIELD);
        ingestMetadata.remove(ON_FAILURE_PROCESSOR_TAG_FIELD);
    }

    private ElasticsearchException newCompoundProcessorException(Exception e, String processorType, String processorTag) {
        if (e instanceof ElasticsearchException && ((ElasticsearchException)e).getHeader("processor_type") != null) {
            return (ElasticsearchException)e;
        }
        ElasticsearchException exception = new ElasticsearchException(new IllegalArgumentException(e));
        if (processorType != null) {
            exception.addHeader("processor_type", processorType);
        }
        if (processorTag != null) {
            exception.addHeader("processor_tag", processorTag);
        }
        return exception;
    }
}

