/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.translog;

import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.store.BufferedChecksum;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.FilterStreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;

public final class BufferedChecksumStreamInput
extends FilterStreamInput {
    private static final int SKIP_BUFFER_SIZE = 1024;
    private byte[] skipBuffer;
    private final Checksum digest;
    private final String source;

    public BufferedChecksumStreamInput(StreamInput in, String source, BufferedChecksumStreamInput reuse) {
        super(in);
        this.source = source;
        if (reuse == null) {
            this.digest = new BufferedChecksum(new CRC32());
        } else {
            this.digest = reuse.digest;
            this.digest.reset();
            this.skipBuffer = reuse.skipBuffer;
        }
    }

    public BufferedChecksumStreamInput(StreamInput in, String source) {
        this(in, source, null);
    }

    public long getChecksum() {
        return this.digest.getValue();
    }

    @Override
    public byte readByte() throws IOException {
        byte b = this.delegate.readByte();
        this.digest.update(b);
        return b;
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.delegate.readBytes(b, offset, len);
        this.digest.update(b, offset, len);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
        this.digest.reset();
    }

    @Override
    public int read() throws IOException {
        return this.readByte() & 0xFF;
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    @Override
    public long skip(long numBytes) throws IOException {
        long skipped;
        int step;
        if (numBytes < 0L) {
            throw new IllegalArgumentException("numBytes must be >= 0, got " + numBytes);
        }
        if (this.skipBuffer == null) {
            this.skipBuffer = new byte[1024];
        }
        assert (this.skipBuffer.length == 1024);
        for (skipped = 0L; skipped < numBytes; skipped += (long)step) {
            step = (int)Math.min(1024L, numBytes - skipped);
            this.readBytes(this.skipBuffer, 0, step);
        }
        return skipped;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    public void resetDigest() {
        this.digest.reset();
    }

    public String getSource() {
        return this.source;
    }
}

