/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.reindex;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.RunOnce;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.reindex.BulkByScrollTask;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.reindex.SuccessfullyProcessed;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.Scheduler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorkerBulkByScrollTaskState
implements SuccessfullyProcessed {
    private static final Logger logger = LogManager.getLogger(WorkerBulkByScrollTaskState.class);
    private static final TimeValue MAX_THROTTLE_WAIT_TIME = TimeValue.timeValueHours(1L);
    private final BulkByScrollTask task;
    private final Integer sliceId;
    private final AtomicLong total = new AtomicLong(0L);
    private final AtomicLong updated = new AtomicLong(0L);
    private final AtomicLong created = new AtomicLong(0L);
    private final AtomicLong deleted = new AtomicLong(0L);
    private final AtomicLong noops = new AtomicLong(0L);
    private final AtomicInteger batch = new AtomicInteger(0);
    private final AtomicLong versionConflicts = new AtomicLong(0L);
    private final AtomicLong bulkRetries = new AtomicLong(0L);
    private final AtomicLong searchRetries = new AtomicLong(0L);
    private final AtomicLong throttledNanos = new AtomicLong();
    private volatile float requestsPerSecond;
    private final AtomicReference<DelayedPrepareBulkRequest> delayedPrepareBulkRequestReference = new AtomicReference();

    public WorkerBulkByScrollTaskState(BulkByScrollTask task, Integer sliceId, float requestsPerSecond) {
        this.task = task;
        this.sliceId = sliceId;
        this.setRequestsPerSecond(requestsPerSecond);
    }

    public BulkByScrollTask.Status getStatus() {
        return new BulkByScrollTask.Status(this.sliceId, this.total.get(), this.updated.get(), this.created.get(), this.deleted.get(), this.batch.get(), this.versionConflicts.get(), this.noops.get(), this.bulkRetries.get(), this.searchRetries.get(), TimeValue.timeValueNanos(this.throttledNanos.get()), this.getRequestsPerSecond(), this.task.getReasonCancelled(), this.throttledUntil());
    }

    public void handleCancel() {
        this.rethrottle(Float.POSITIVE_INFINITY);
    }

    public void setTotal(long totalHits) {
        this.total.set(totalHits);
    }

    public void countBatch() {
        this.batch.incrementAndGet();
    }

    public void countNoop() {
        this.noops.incrementAndGet();
    }

    @Override
    public long getCreated() {
        return this.created.get();
    }

    public void countCreated() {
        this.created.incrementAndGet();
    }

    @Override
    public long getUpdated() {
        return this.updated.get();
    }

    public void countUpdated() {
        this.updated.incrementAndGet();
    }

    @Override
    public long getDeleted() {
        return this.deleted.get();
    }

    public void countDeleted() {
        this.deleted.incrementAndGet();
    }

    public void countVersionConflict() {
        this.versionConflicts.incrementAndGet();
    }

    public void countBulkRetry() {
        this.bulkRetries.incrementAndGet();
    }

    public void countSearchRetry() {
        this.searchRetries.incrementAndGet();
    }

    float getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    TimeValue throttledUntil() {
        DelayedPrepareBulkRequest delayed = this.delayedPrepareBulkRequestReference.get();
        if (delayed == null) {
            return TimeValue.timeValueNanos(0L);
        }
        if (delayed.scheduled == null) {
            return TimeValue.timeValueNanos(0L);
        }
        return TimeValue.timeValueNanos(Math.max(0L, delayed.scheduled.getDelay(TimeUnit.NANOSECONDS)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delayPrepareBulkRequest(ThreadPool threadPool, long lastBatchStartTimeNS, int lastBatchSize, AbstractRunnable prepareBulkRequestRunnable) {
        AtomicReference<DelayedPrepareBulkRequest> atomicReference = this.delayedPrepareBulkRequestReference;
        synchronized (atomicReference) {
            TimeValue delay = this.throttleWaitTime(lastBatchStartTimeNS, System.nanoTime(), lastBatchSize);
            logger.debug("[{}]: preparing bulk request for [{}]", (Object)this.task.getId(), (Object)delay);
            try {
                this.delayedPrepareBulkRequestReference.set(new DelayedPrepareBulkRequest(threadPool, this.getRequestsPerSecond(), delay, new RunOnce(prepareBulkRequestRunnable)));
            }
            catch (EsRejectedExecutionException e) {
                prepareBulkRequestRunnable.onRejection(e);
            }
        }
    }

    public TimeValue throttleWaitTime(long lastBatchStartTimeNS, long nowNS, int lastBatchSize) {
        long earliestNextBatchStartTime = nowNS + (long)this.perfectlyThrottledBatchTime(lastBatchSize);
        long waitTime = Math.min(MAX_THROTTLE_WAIT_TIME.nanos(), Math.max(0L, earliestNextBatchStartTime - System.nanoTime()));
        return TimeValue.timeValueNanos(waitTime);
    }

    float perfectlyThrottledBatchTime(int lastBatchSize) {
        if (this.requestsPerSecond == Float.POSITIVE_INFINITY) {
            return 0.0f;
        }
        float targetBatchTimeInSeconds = (float)lastBatchSize / this.requestsPerSecond;
        return (float)TimeUnit.SECONDS.toNanos(1L) * targetBatchTimeInSeconds;
    }

    private void setRequestsPerSecond(float requestsPerSecond) {
        if (requestsPerSecond <= 0.0f) {
            throw new IllegalArgumentException("requests per second must be more than 0 but was [" + requestsPerSecond + "]");
        }
        this.requestsPerSecond = requestsPerSecond;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rethrottle(float newRequestsPerSecond) {
        AtomicReference<DelayedPrepareBulkRequest> atomicReference = this.delayedPrepareBulkRequestReference;
        synchronized (atomicReference) {
            logger.debug("[{}]: rethrottling to [{}] requests per second", (Object)this.task.getId(), (Object)Float.valueOf(newRequestsPerSecond));
            this.setRequestsPerSecond(newRequestsPerSecond);
            DelayedPrepareBulkRequest delayedPrepareBulkRequest = this.delayedPrepareBulkRequestReference.get();
            if (delayedPrepareBulkRequest == null) {
                logger.debug("[{}]: skipping rescheduling because there is no scheduled task", (Object)this.task.getId());
                return;
            }
            this.delayedPrepareBulkRequestReference.set(delayedPrepareBulkRequest.rethrottle(newRequestsPerSecond));
        }
    }

    class DelayedPrepareBulkRequest {
        private final ThreadPool threadPool;
        private final Runnable command;
        private final float requestsPerSecond;
        private final Scheduler.ScheduledCancellable scheduled;

        DelayedPrepareBulkRequest(ThreadPool threadPool, float requestsPerSecond, TimeValue delay, Runnable command) {
            this.threadPool = threadPool;
            this.requestsPerSecond = requestsPerSecond;
            this.command = command;
            this.scheduled = threadPool.schedule(() -> {
                WorkerBulkByScrollTaskState.this.throttledNanos.addAndGet(delay.nanos());
                command.run();
            }, delay, "generic");
        }

        DelayedPrepareBulkRequest rethrottle(float newRequestsPerSecond) {
            if (newRequestsPerSecond < this.requestsPerSecond) {
                logger.debug("[{}]: skipping rescheduling because the new throttle [{}] is slower than the old one [{}]", (Object)WorkerBulkByScrollTaskState.this.task.getId(), (Object)Float.valueOf(newRequestsPerSecond), (Object)Float.valueOf(this.requestsPerSecond));
                return this;
            }
            long remainingDelay = this.scheduled.getDelay(TimeUnit.NANOSECONDS);
            if (this.scheduled == null || !this.scheduled.cancel()) {
                logger.debug("[{}]: skipping rescheduling because we couldn't cancel the task", (Object)WorkerBulkByScrollTaskState.this.task.getId());
                return this;
            }
            TimeValue newDelay = this.newDelay(remainingDelay, newRequestsPerSecond);
            logger.debug("[{}]: rescheduling for [{}] in the future", (Object)WorkerBulkByScrollTaskState.this.task.getId(), (Object)newDelay);
            return new DelayedPrepareBulkRequest(this.threadPool, this.requestsPerSecond, newDelay, this.command);
        }

        TimeValue newDelay(long remainingDelay, float newRequestsPerSecond) {
            if (remainingDelay < 0L) {
                return TimeValue.timeValueNanos(0L);
            }
            return TimeValue.timeValueNanos(Math.round((float)remainingDelay * this.requestsPerSecond / newRequestsPerSecond));
        }
    }
}

