/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.reindex;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.SearchRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.reindex.AbstractBulkByScrollRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.Script;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.tasks.TaskId;

public abstract class AbstractBulkIndexByScrollRequest<Self extends AbstractBulkIndexByScrollRequest<Self>>
extends AbstractBulkByScrollRequest<Self> {
    private Script script;

    public AbstractBulkIndexByScrollRequest() {
    }

    protected AbstractBulkIndexByScrollRequest(SearchRequest searchRequest, boolean setDefaults) {
        super(searchRequest, setDefaults);
    }

    public Script getScript() {
        return this.script;
    }

    public Self setScript(@Nullable Script script) {
        this.script = script;
        return (Self)((AbstractBulkIndexByScrollRequest)this.self());
    }

    @Override
    protected Self doForSlice(Self request, TaskId slicingTask, int totalSlices) {
        return ((AbstractBulkIndexByScrollRequest)super.doForSlice(request, slicingTask, totalSlices)).setScript(this.script);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.readBoolean()) {
            this.script = new Script(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable(this.script);
    }

    @Override
    protected void searchToString(StringBuilder b) {
        super.searchToString(b);
        if (this.script != null) {
            b.append(" updated with ").append(this.script);
        }
    }
}

