/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.rankeval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.NamedWriteable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.rankeval.EvalQueryQuality;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.rankeval.RatedDocument;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.rankeval.RatedSearchHit;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.SearchHit;

public interface EvaluationMetric
extends ToXContentObject,
NamedWriteable {
    public EvalQueryQuality evaluate(String var1, SearchHit[] var2, List<RatedDocument> var3);

    public static List<RatedSearchHit> joinHitsWithRatings(SearchHit[] hits, List<RatedDocument> ratedDocs) {
        Map<RatedDocument.DocumentKey, RatedDocument> ratedDocumentMap = ratedDocs.stream().collect(Collectors.toMap(RatedDocument::getKey, item -> item));
        ArrayList<RatedSearchHit> ratedSearchHits = new ArrayList<RatedSearchHit>(hits.length);
        for (SearchHit hit : hits) {
            RatedDocument.DocumentKey key = new RatedDocument.DocumentKey(hit.getIndex(), hit.getId());
            RatedDocument ratedDoc = ratedDocumentMap.get(key);
            if (ratedDoc != null) {
                ratedSearchHits.add(new RatedSearchHit(hit, Optional.of(ratedDoc.getRating())));
                continue;
            }
            ratedSearchHits.add(new RatedSearchHit(hit, Optional.empty()));
        }
        return ratedSearchHits;
    }

    public static List<RatedDocument.DocumentKey> filterUnratedDocuments(List<RatedSearchHit> ratedHits) {
        return ratedHits.stream().filter(hit -> !hit.getRating().isPresent()).map(hit -> new RatedDocument.DocumentKey(hit.getSearchHit().getIndex(), hit.getSearchHit().getId())).collect(Collectors.toList());
    }

    default public double combine(Collection<EvalQueryQuality> partialResults) {
        return partialResults.stream().mapToDouble(EvalQueryQuality::metricScore).sum() / (double)partialResults.size();
    }

    default public Optional<Integer> forcedSearchSize() {
        return Optional.empty();
    }
}

