/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.collect.CopyOnWriteHashMap;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.regex.Regex;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.FieldAliasMapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.FieldMapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MappedFieldType;

class FieldTypeLookup
implements Iterable<MappedFieldType> {
    final CopyOnWriteHashMap<String, MappedFieldType> fullNameToFieldType;
    private final CopyOnWriteHashMap<String, String> aliasToConcreteName;
    private final CopyOnWriteHashMap<String, Set<String>> fullNameToTypes;

    FieldTypeLookup() {
        this.fullNameToFieldType = new CopyOnWriteHashMap();
        this.aliasToConcreteName = new CopyOnWriteHashMap();
        this.fullNameToTypes = new CopyOnWriteHashMap();
    }

    private FieldTypeLookup(CopyOnWriteHashMap<String, MappedFieldType> fullNameToFieldType, CopyOnWriteHashMap<String, String> aliasToConcreteName, CopyOnWriteHashMap<String, Set<String>> fullNameToTypes) {
        this.fullNameToFieldType = fullNameToFieldType;
        this.aliasToConcreteName = aliasToConcreteName;
        this.fullNameToTypes = fullNameToTypes;
    }

    private static CopyOnWriteHashMap<String, Set<String>> addType(CopyOnWriteHashMap<String, Set<String>> map, String key, String type) {
        Set<String> types = map.get(key);
        if (types == null) {
            return map.copyAndPut(key, Collections.singleton(type));
        }
        if (types.contains(type)) {
            return map;
        }
        Set<String> newTypes = new HashSet<String>(types.size() + 1);
        newTypes.addAll(types);
        newTypes.add(type);
        assert (newTypes.size() == types.size() + 1);
        newTypes = Collections.unmodifiableSet(newTypes);
        return map.copyAndPut(key, newTypes);
    }

    public FieldTypeLookup copyAndAddAll(String type, Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers, boolean updateAllTypes) {
        Objects.requireNonNull(type, "type must not be null");
        if ("_default_".equals(type)) {
            throw new IllegalArgumentException("Default mappings should not be added to the lookup");
        }
        CopyOnWriteHashMap<String, MappedFieldType> fullName = this.fullNameToFieldType;
        CopyOnWriteHashMap<String, String> aliases = this.aliasToConcreteName;
        CopyOnWriteHashMap<String, Set<String>> fullNameToTypes = this.fullNameToTypes;
        for (FieldMapper fieldMapper : fieldMappers) {
            MappedFieldType fullNameFieldType;
            MappedFieldType fieldType = fieldMapper.fieldType();
            if (!Objects.equals(fieldType, fullNameFieldType = fullName.get(fieldType.name()))) {
                this.validateField(type, fullNameFieldType, fieldType, aliases, updateAllTypes);
                fullName = fullName.copyAndPut(fieldType.name(), fieldType);
            }
            fullNameToTypes = FieldTypeLookup.addType(fullNameToTypes, fieldType.name(), type);
        }
        for (FieldAliasMapper fieldAliasMapper : fieldAliasMappers) {
            String aliasName = fieldAliasMapper.name();
            String path = fieldAliasMapper.path();
            this.validateAlias(aliasName, path, aliases, fullName);
            aliases = aliases.copyAndPut(aliasName, path);
        }
        return new FieldTypeLookup(fullName, aliases, fullNameToTypes);
    }

    private static boolean beStrict(String type, Set<String> types, boolean updateAllTypes) {
        assert (types.size() >= 1);
        if (updateAllTypes) {
            return false;
        }
        return types.size() != 1 || !types.contains(type);
    }

    private void validateField(String type, MappedFieldType existingFieldType, MappedFieldType newFieldType, CopyOnWriteHashMap<String, String> aliasToConcreteName, boolean updateAllTypes) {
        String fieldName = newFieldType.name();
        if (aliasToConcreteName.containsKey(fieldName)) {
            throw new IllegalArgumentException("The name for field [" + fieldName + "] has already been used to define a field alias.");
        }
        if (existingFieldType != null) {
            ArrayList<String> conflicts = new ArrayList<String>();
            Set<String> types = this.fullNameToTypes.get(newFieldType.name());
            boolean strict = FieldTypeLookup.beStrict(type, types, updateAllTypes);
            existingFieldType.checkCompatibility(newFieldType, conflicts, strict);
            if (!conflicts.isEmpty()) {
                throw new IllegalArgumentException("Mapper for [" + fieldName + "] conflicts with existing mapping in other types:\n" + ((Object)conflicts).toString());
            }
        }
    }

    private void validateAlias(String aliasName, String path, CopyOnWriteHashMap<String, String> aliasToConcreteName, CopyOnWriteHashMap<String, MappedFieldType> fullNameToFieldType) {
        if (fullNameToFieldType.containsKey(aliasName)) {
            throw new IllegalArgumentException("The name for field alias [" + aliasName + "] has already been used to define a concrete field.");
        }
        if (path.equals(aliasName)) {
            throw new IllegalArgumentException("Invalid [path] value [" + path + "] for field alias [" + aliasName + "]: an alias cannot refer to itself.");
        }
        if (aliasToConcreteName.containsKey(path)) {
            throw new IllegalArgumentException("Invalid [path] value [" + path + "] for field alias [" + aliasName + "]: an alias cannot refer to another alias.");
        }
        if (!fullNameToFieldType.containsKey(path)) {
            throw new IllegalArgumentException("Invalid [path] value [" + path + "] for field alias [" + aliasName + "]: an alias must refer to an existing field in the mappings.");
        }
    }

    public MappedFieldType get(String field) {
        String concreteField = this.aliasToConcreteName.getOrDefault(field, field);
        return this.fullNameToFieldType.get(concreteField);
    }

    protected Set<String> getTypes(String field) {
        Set<String> types = this.fullNameToTypes.get(field);
        if (types == null) {
            types = Collections.emptySet();
        }
        return types;
    }

    public Collection<String> simpleMatchToFullName(String pattern) {
        HashSet<String> fields = new HashSet<String>();
        for (MappedFieldType fieldType : this) {
            if (!Regex.simpleMatch(pattern, fieldType.name())) continue;
            fields.add(fieldType.name());
        }
        for (String aliasName : this.aliasToConcreteName.keySet()) {
            if (!Regex.simpleMatch(pattern, aliasName)) continue;
            fields.add(aliasName);
        }
        return fields;
    }

    @Override
    public Iterator<MappedFieldType> iterator() {
        return this.fullNameToFieldType.values().iterator();
    }
}

