/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.codecs.PostingsFormat;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexableField;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.TermQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.suggest.document.Completion50PostingsFormat;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.suggest.document.CompletionAnalyzer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.suggest.document.CompletionQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.suggest.document.FuzzyCompletionQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.suggest.document.PrefixCompletionQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.suggest.document.RegexCompletionQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.suggest.document.SuggestField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParsingException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.Fuzziness;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.set.Sets;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.AnalyzerScope;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.NamedAnalyzer;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.ArrayValueMapperParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.FieldMapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.MapperParsingException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.ParseContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.TermBasedFieldType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.mapper.TypeParsers;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.suggest.completion.context.ContextMapping;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.suggest.completion.context.ContextMappings;

public class CompletionFieldMapper
extends FieldMapper
implements ArrayValueMapperParser {
    public static final String CONTENT_TYPE = "completion";
    public static final Set<String> ALLOWED_CONTENT_FIELD_NAMES = Sets.newHashSet("input", "weight", "contexts");
    private int maxInputLength;

    public CompletionFieldMapper(String simpleName, MappedFieldType fieldType, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, int maxInputLength) {
        super(simpleName, fieldType, Defaults.FIELD_TYPE, indexSettings, multiFields, copyTo);
        this.maxInputLength = maxInputLength;
    }

    @Override
    public CompletionFieldType fieldType() {
        return (CompletionFieldType)super.fieldType();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void parse(ParseContext context) throws IOException {
        XContentParser parser = context.parser();
        XContentParser.Token token = parser.currentToken();
        Map<Object, Object> inputMap = new HashMap(1);
        if (context.externalValueSet()) {
            inputMap = this.getInputMapFromExternalValue(context);
        } else {
            if (token == XContentParser.Token.VALUE_NULL) {
                return;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    this.parse(context, token, parser, inputMap);
                }
            } else {
                this.parse(context, token, parser, inputMap);
            }
        }
        for (Map.Entry<Object, Object> completionInput : inputMap.entrySet()) {
            void var7_7;
            String string = (String)completionInput.getKey();
            if (string.trim().isEmpty()) {
                context.addIgnoredField(this.fieldType.name());
                continue;
            }
            if (string.length() > this.maxInputLength) {
                int len = Math.min(this.maxInputLength, string.length());
                if (Character.isHighSurrogate(string.charAt(len - 1))) {
                    assert (string.length() >= len + 1 && Character.isLowSurrogate(string.charAt(len)));
                    ++len;
                }
                String string2 = string.substring(0, len);
            }
            CompletionInputMetaData metaData = (CompletionInputMetaData)completionInput.getValue();
            if (this.fieldType().hasContextMappings()) {
                this.fieldType().getContextMappings().addField(context.doc(), this.fieldType().name(), (String)var7_7, metaData.weight, metaData.contexts);
                continue;
            }
            context.doc().add(new SuggestField(this.fieldType().name(), (String)var7_7, metaData.weight));
        }
        ArrayList<IndexableField> fields = new ArrayList<IndexableField>(1);
        this.createFieldNamesField(context, fields);
        for (IndexableField indexableField : fields) {
            context.doc().add(indexableField);
        }
        for (CompletionInputMetaData completionInputMetaData : inputMap.values()) {
            ParseContext externalValueContext = context.createExternalValueContext(completionInputMetaData);
            this.multiFields.parse(this, externalValueContext);
        }
    }

    private Map<String, CompletionInputMetaData> getInputMapFromExternalValue(ParseContext context) {
        Map<String, CompletionInputMetaData> inputMap;
        if (this.isExternalValueOfClass(context, CompletionInputMetaData.class)) {
            CompletionInputMetaData inputAndMeta = (CompletionInputMetaData)context.externalValue();
            inputMap = Collections.singletonMap(inputAndMeta.input, inputAndMeta);
        } else {
            String fieldName = context.externalValue().toString();
            inputMap = Collections.singletonMap(fieldName, new CompletionInputMetaData(fieldName, Collections.emptyMap(), 1));
        }
        return inputMap;
    }

    private boolean isExternalValueOfClass(ParseContext context, Class<?> clazz) {
        return context.externalValue().getClass().equals(clazz);
    }

    private void parse(ParseContext parseContext, XContentParser.Token token, XContentParser parser, Map<String, CompletionInputMetaData> inputMap) throws IOException {
        String currentFieldName = null;
        if (token == XContentParser.Token.VALUE_STRING) {
            inputMap.put(parser.text(), new CompletionInputMetaData(parser.text(), Collections.emptyMap(), 1));
        } else if (token == XContentParser.Token.START_OBJECT) {
            HashSet<String> inputs = new HashSet<String>();
            int weight = 1;
            HashMap<String, Set<String>> contextsMap = new HashMap<String, Set<String>>();
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    if (ALLOWED_CONTENT_FIELD_NAMES.contains(currentFieldName)) continue;
                    throw new IllegalArgumentException("unknown field name [" + currentFieldName + "], must be one of " + ALLOWED_CONTENT_FIELD_NAMES);
                }
                if (currentFieldName == null) continue;
                if ("input".equals(currentFieldName)) {
                    if (token == XContentParser.Token.VALUE_STRING) {
                        inputs.add(parser.text());
                        continue;
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            if (token == XContentParser.Token.VALUE_STRING) {
                                inputs.add(parser.text());
                                continue;
                            }
                            throw new IllegalArgumentException("input array must have string values, but was [" + token.name() + "]");
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("input must be a string or array, but was [" + token.name() + "]");
                }
                if ("weight".equals(currentFieldName)) {
                    Number weightValue;
                    if (token == XContentParser.Token.VALUE_STRING) {
                        try {
                            weightValue = Long.parseLong(parser.text());
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalArgumentException("weight must be an integer, but was [" + parser.text() + "]");
                        }
                    } else if (token == XContentParser.Token.VALUE_NUMBER) {
                        XContentParser.NumberType numberType = parser.numberType();
                        if (XContentParser.NumberType.LONG != numberType && XContentParser.NumberType.INT != numberType) {
                            throw new IllegalArgumentException("weight must be an integer, but was [" + parser.numberValue() + "]");
                        }
                        weightValue = parser.numberValue();
                    } else {
                        throw new IllegalArgumentException("weight must be a number or string, but was [" + token.name() + "]");
                    }
                    if (weightValue.longValue() < 0L || weightValue.longValue() > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("weight must be in the interval [0..2147483647], but was [" + weightValue.longValue() + "]");
                    }
                    weight = weightValue.intValue();
                    continue;
                }
                if (!"contexts".equals(currentFieldName)) continue;
                if (!this.fieldType().hasContextMappings()) {
                    throw new IllegalArgumentException("contexts field is not supported for field: [" + this.fieldType().name() + "]");
                }
                ContextMappings contextMappings = this.fieldType().getContextMappings();
                XContentParser.Token currentToken = parser.currentToken();
                if (currentToken == XContentParser.Token.START_OBJECT) {
                    ContextMapping contextMapping = null;
                    String fieldName = null;
                    while ((currentToken = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        if (currentToken == XContentParser.Token.FIELD_NAME) {
                            fieldName = parser.currentName();
                            contextMapping = contextMappings.get(fieldName);
                            continue;
                        }
                        assert (fieldName != null);
                        assert (!contextsMap.containsKey(fieldName));
                        contextsMap.put(fieldName, contextMapping.parseContext(parseContext, parser));
                    }
                    continue;
                }
                throw new IllegalArgumentException("contexts must be an object or an array , but was [" + (Object)((Object)currentToken) + "]");
            }
            for (String input : inputs) {
                if (inputMap.containsKey(input) && inputMap.get((Object)input).weight >= weight) continue;
                inputMap.put(input, new CompletionInputMetaData(input, contextsMap, weight));
            }
        } else {
            throw new ParsingException(parser.getTokenLocation(), "failed to parse [" + parser.currentName() + "]: expected text or object, but got " + token.name(), new Object[0]);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.simpleName()).field(Fields.TYPE.getPreferredName(), CONTENT_TYPE);
        builder.field(Fields.ANALYZER.getPreferredName(), this.fieldType().indexAnalyzer().name());
        if (!this.fieldType().indexAnalyzer().name().equals(this.fieldType().searchAnalyzer().name())) {
            builder.field(Fields.SEARCH_ANALYZER.getPreferredName(), this.fieldType().searchAnalyzer().name());
        }
        builder.field(Fields.PRESERVE_SEPARATORS.getPreferredName(), this.fieldType().preserveSep());
        builder.field(Fields.PRESERVE_POSITION_INCREMENTS.getPreferredName(), this.fieldType().preservePositionIncrements());
        builder.field(Fields.MAX_INPUT_LENGTH.getPreferredName(), this.maxInputLength);
        if (this.fieldType().hasContextMappings()) {
            builder.startArray(Fields.CONTEXTS.getPreferredName());
            this.fieldType().getContextMappings().toXContent(builder, params);
            builder.endArray();
        }
        this.multiFields.toXContent(builder, params);
        return builder.endObject();
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        CompletionFieldMapper fieldMergeWith = (CompletionFieldMapper)mergeWith;
        this.maxInputLength = fieldMergeWith.maxInputLength;
    }

    static class CompletionInputMetaData {
        public final String input;
        public final Map<String, Set<String>> contexts;
        public final int weight;

        CompletionInputMetaData(String input, Map<String, Set<String>> contexts, int weight) {
            this.input = input;
            this.contexts = contexts;
            this.weight = weight;
        }

        public String toString() {
            return this.input;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, CompletionFieldMapper> {
        private int maxInputLength = 50;
        private ContextMappings contextMappings = null;
        private boolean preserveSeparators = true;
        private boolean preservePositionIncrements = true;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        public Builder maxInputLength(int maxInputLength) {
            if (maxInputLength <= 0) {
                throw new IllegalArgumentException(Fields.MAX_INPUT_LENGTH.getPreferredName() + " must be > 0 but was [" + maxInputLength + "]");
            }
            this.maxInputLength = maxInputLength;
            return this;
        }

        public Builder contextMappings(ContextMappings contextMappings) {
            this.contextMappings = contextMappings;
            return this;
        }

        public Builder preserveSeparators(boolean preserveSeparators) {
            this.preserveSeparators = preserveSeparators;
            return this;
        }

        public Builder preservePositionIncrements(boolean preservePositionIncrements) {
            this.preservePositionIncrements = preservePositionIncrements;
            return this;
        }

        @Override
        public CompletionFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            CompletionFieldType completionFieldType = (CompletionFieldType)this.fieldType;
            completionFieldType.setContextMappings(this.contextMappings);
            completionFieldType.setPreservePositionIncrements(this.preservePositionIncrements);
            completionFieldType.setPreserveSep(this.preserveSeparators);
            return new CompletionFieldMapper(this.name, this.fieldType, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo, this.maxInputLength);
        }
    }

    public static final class CompletionFieldType
    extends TermBasedFieldType {
        private static PostingsFormat postingsFormat;
        private boolean preserveSep = true;
        private boolean preservePositionIncrements = true;
        private ContextMappings contextMappings = null;

        public CompletionFieldType() {
        }

        private CompletionFieldType(CompletionFieldType ref) {
            super(ref);
            this.contextMappings = ref.contextMappings;
            this.preserveSep = ref.preserveSep;
            this.preservePositionIncrements = ref.preservePositionIncrements;
        }

        public void setPreserveSep(boolean preserveSep) {
            this.checkIfFrozen();
            this.preserveSep = preserveSep;
        }

        public void setPreservePositionIncrements(boolean preservePositionIncrements) {
            this.checkIfFrozen();
            this.preservePositionIncrements = preservePositionIncrements;
        }

        public void setContextMappings(ContextMappings contextMappings) {
            this.checkIfFrozen();
            this.contextMappings = contextMappings;
        }

        @Override
        public NamedAnalyzer indexAnalyzer() {
            NamedAnalyzer indexAnalyzer = super.indexAnalyzer();
            if (indexAnalyzer != null && !(indexAnalyzer.analyzer() instanceof CompletionAnalyzer)) {
                return new NamedAnalyzer(indexAnalyzer.name(), AnalyzerScope.INDEX, new CompletionAnalyzer(indexAnalyzer, this.preserveSep, this.preservePositionIncrements));
            }
            return indexAnalyzer;
        }

        @Override
        public NamedAnalyzer searchAnalyzer() {
            NamedAnalyzer searchAnalyzer = super.searchAnalyzer();
            if (searchAnalyzer != null && !(searchAnalyzer.analyzer() instanceof CompletionAnalyzer)) {
                return new NamedAnalyzer(searchAnalyzer.name(), AnalyzerScope.INDEX, new CompletionAnalyzer(searchAnalyzer, this.preserveSep, this.preservePositionIncrements));
            }
            return searchAnalyzer;
        }

        public boolean hasContextMappings() {
            return this.contextMappings != null;
        }

        public ContextMappings getContextMappings() {
            return this.contextMappings;
        }

        public boolean preserveSep() {
            return this.preserveSep;
        }

        public boolean preservePositionIncrements() {
            return this.preservePositionIncrements;
        }

        public static synchronized PostingsFormat postingsFormat() {
            if (postingsFormat == null) {
                postingsFormat = new Completion50PostingsFormat();
            }
            return postingsFormat;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new TermQuery(new Term("_field_names", this.name()));
        }

        public CompletionQuery prefixQuery(Object value) {
            return new PrefixCompletionQuery(this.searchAnalyzer().analyzer(), new Term(this.name(), this.indexedValueForSearch(value)));
        }

        public CompletionQuery regexpQuery(Object value, int flags, int maxDeterminizedStates) {
            return new RegexCompletionQuery(new Term(this.name(), this.indexedValueForSearch(value)), flags, maxDeterminizedStates);
        }

        public CompletionQuery fuzzyQuery(String value, Fuzziness fuzziness, int nonFuzzyPrefixLength, int minFuzzyPrefixLength, int maxExpansions, boolean transpositions, boolean unicodeAware) {
            return new FuzzyCompletionQuery(this.searchAnalyzer().analyzer(), new Term(this.name(), this.indexedValueForSearch(value)), null, fuzziness.asDistance(), transpositions, nonFuzzyPrefixLength, minFuzzyPrefixLength, unicodeAware, maxExpansions);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CompletionFieldType that = (CompletionFieldType)o;
            if (this.preserveSep != that.preserveSep) {
                return false;
            }
            if (this.preservePositionIncrements != that.preservePositionIncrements) {
                return false;
            }
            return !(this.contextMappings == null ? that.contextMappings != null : !this.contextMappings.equals(that.contextMappings));
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.preserveSep, this.preservePositionIncrements, this.contextMappings);
        }

        @Override
        public CompletionFieldType clone() {
            return new CompletionFieldType(this);
        }

        @Override
        public String typeName() {
            return CompletionFieldMapper.CONTENT_TYPE;
        }

        @Override
        public void checkCompatibility(MappedFieldType fieldType, List<String> conflicts, boolean strict) {
            super.checkCompatibility(fieldType, conflicts, strict);
            CompletionFieldType other = (CompletionFieldType)fieldType;
            if (this.preservePositionIncrements != other.preservePositionIncrements) {
                conflicts.add("mapper [" + this.name() + "] has different [preserve_position_increments] values");
            }
            if (this.preserveSep != other.preserveSep) {
                conflicts.add("mapper [" + this.name() + "] has different [preserve_separators] values");
            }
            if (this.hasContextMappings() != other.hasContextMappings()) {
                conflicts.add("mapper [" + this.name() + "] has different [context_mappings] values");
            } else if (this.hasContextMappings() && !this.contextMappings.equals(other.contextMappings)) {
                conflicts.add("mapper [" + this.name() + "] has different [context_mappings] values");
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            NamedAnalyzer indexAnalyzer = null;
            NamedAnalyzer searchAnalyzer = null;
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (fieldName.equals("type")) continue;
                if (Fields.ANALYZER.match(fieldName, LoggingDeprecationHandler.INSTANCE)) {
                    indexAnalyzer = this.getNamedAnalyzer(parserContext, fieldNode.toString());
                    iterator.remove();
                    continue;
                }
                if (Fields.SEARCH_ANALYZER.match(fieldName, LoggingDeprecationHandler.INSTANCE)) {
                    searchAnalyzer = this.getNamedAnalyzer(parserContext, fieldNode.toString());
                    iterator.remove();
                    continue;
                }
                if (Fields.PRESERVE_SEPARATORS.match(fieldName, LoggingDeprecationHandler.INSTANCE)) {
                    builder.preserveSeparators(Boolean.parseBoolean(fieldNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (Fields.PRESERVE_POSITION_INCREMENTS.match(fieldName, LoggingDeprecationHandler.INSTANCE)) {
                    builder.preservePositionIncrements(Boolean.parseBoolean(fieldNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (Fields.MAX_INPUT_LENGTH.match(fieldName, LoggingDeprecationHandler.INSTANCE)) {
                    builder.maxInputLength(Integer.parseInt(fieldNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (Fields.CONTEXTS.match(fieldName, LoggingDeprecationHandler.INSTANCE)) {
                    builder.contextMappings(ContextMappings.load(fieldNode, parserContext.indexVersionCreated()));
                    iterator.remove();
                    continue;
                }
                if (!TypeParsers.parseMultiField(builder, name, parserContext, fieldName, fieldNode)) continue;
                iterator.remove();
            }
            if (indexAnalyzer == null) {
                if (searchAnalyzer != null) {
                    throw new MapperParsingException("analyzer on completion field [" + name + "] must be set when search_analyzer is set");
                }
                indexAnalyzer = searchAnalyzer = parserContext.getIndexAnalyzers().get("simple");
            } else if (searchAnalyzer == null) {
                searchAnalyzer = indexAnalyzer;
            }
            builder.indexAnalyzer(indexAnalyzer);
            builder.searchAnalyzer(searchAnalyzer);
            return builder;
        }

        private NamedAnalyzer getNamedAnalyzer(Mapper.TypeParser.ParserContext parserContext, String name) {
            NamedAnalyzer analyzer = parserContext.getIndexAnalyzers().get(name);
            if (analyzer == null) {
                throw new IllegalArgumentException("Can't find default or mapped analyzer with name [" + name + "]");
            }
            return analyzer;
        }
    }

    public static class Fields {
        public static final ParseField ANALYZER = new ParseField("analyzer", new String[0]);
        public static final ParseField SEARCH_ANALYZER = new ParseField("search_analyzer", new String[0]);
        public static final ParseField PRESERVE_SEPARATORS = new ParseField("preserve_separators", new String[0]);
        public static final ParseField PRESERVE_POSITION_INCREMENTS = new ParseField("preserve_position_increments", new String[0]);
        public static final ParseField TYPE = new ParseField("type", new String[0]);
        public static final ParseField CONTEXTS = new ParseField("contexts", new String[0]);
        public static final ParseField MAX_INPUT_LENGTH = new ParseField("max_input_length", "max_input_len");
        public static final String CONTENT_FIELD_NAME_INPUT = "input";
        public static final String CONTENT_FIELD_NAME_WEIGHT = "weight";
        public static final String CONTENT_FIELD_NAME_CONTEXTS = "contexts";
    }

    public static class Defaults {
        public static final MappedFieldType FIELD_TYPE = new CompletionFieldType();
        public static final boolean DEFAULT_PRESERVE_SEPARATORS = true;
        public static final boolean DEFAULT_POSITION_INCREMENTS = true;
        public static final int DEFAULT_MAX_INPUT_LENGTH = 50;

        static {
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.freeze();
        }
    }
}

