/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.engine;

import java.util.Collection;
import java.util.Collections;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.RamUsageEstimator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.translog.Translog;

abstract class VersionValue
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(VersionValue.class);
    final long version;
    final long seqNo;
    final long term;

    VersionValue(long version, long seqNo, long term) {
        this.version = version;
        this.seqNo = seqNo;
        this.term = term;
    }

    public boolean isDelete() {
        return false;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED;
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionValue that = (VersionValue)o;
        if (this.version != that.version) {
            return false;
        }
        if (this.seqNo != that.seqNo) {
            return false;
        }
        return this.term == that.term;
    }

    public int hashCode() {
        int result = (int)(this.version ^ this.version >>> 32);
        result = 31 * result + (int)(this.seqNo ^ this.seqNo >>> 32);
        result = 31 * result + (int)(this.term ^ this.term >>> 32);
        return result;
    }

    public String toString() {
        return "VersionValue{version=" + this.version + ", seqNo=" + this.seqNo + ", term=" + this.term + '}';
    }

    @Nullable
    public Translog.Location getLocation() {
        return null;
    }
}

