/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis;

import java.util.Locale;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.hunspell.HunspellStemFilter;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.indices.analysis.HunspellService;

public class HunspellTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final Dictionary dictionary;
    private final boolean dedup;
    private final boolean longestOnly;

    public HunspellTokenFilterFactory(IndexSettings indexSettings, String name, Settings settings, HunspellService hunspellService) {
        super(indexSettings, name, settings);
        String locale = settings.get("locale", settings.get("language", settings.get("lang", null)));
        if (locale == null) {
            throw new IllegalArgumentException("missing [locale | language | lang] configuration for hunspell token filter");
        }
        this.dictionary = hunspellService.getDictionary(locale);
        if (this.dictionary == null) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown hunspell dictionary for locale [%s]", locale));
        }
        this.dedup = settings.getAsBooleanLenientForPreEs6Indices(indexSettings.getIndexVersionCreated(), "dedup", true, this.deprecationLogger);
        this.longestOnly = settings.getAsBooleanLenientForPreEs6Indices(indexSettings.getIndexVersionCreated(), "longest_only", false, this.deprecationLogger);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return new HunspellStemFilter(tokenStream, this.dictionary, this.dedup, this.longestOnly);
    }

    public boolean dedup() {
        return this.dedup;
    }

    public boolean longestOnly() {
        return this.longestOnly;
    }
}

