/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.discovery.zen;

import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.MetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.node.DiscoveryNodes;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportChannel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportRequestHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MembershipAction {
    private static final Logger logger = LogManager.getLogger(MembershipAction.class);
    public static final String DISCOVERY_JOIN_ACTION_NAME = "internal:discovery/zen/join";
    public static final String DISCOVERY_JOIN_VALIDATE_ACTION_NAME = "internal:discovery/zen/join/validate";
    public static final String DISCOVERY_LEAVE_ACTION_NAME = "internal:discovery/zen/leave";
    private final TransportService transportService;
    private final MembershipListener listener;

    public MembershipAction(TransportService transportService, MembershipListener listener, Collection<BiConsumer<DiscoveryNode, ClusterState>> joinValidators) {
        this.transportService = transportService;
        this.listener = listener;
        transportService.registerRequestHandler(DISCOVERY_JOIN_ACTION_NAME, JoinRequest::new, "generic", new JoinRequestRequestHandler());
        transportService.registerRequestHandler(DISCOVERY_JOIN_VALIDATE_ACTION_NAME, () -> new ValidateJoinRequest(), "generic", new ValidateJoinRequestRequestHandler(transportService::getLocalNode, joinValidators));
        transportService.registerRequestHandler(DISCOVERY_LEAVE_ACTION_NAME, LeaveRequest::new, "generic", new LeaveRequestRequestHandler());
    }

    public void sendLeaveRequest(DiscoveryNode masterNode, DiscoveryNode node) {
        this.transportService.sendRequest(node, DISCOVERY_LEAVE_ACTION_NAME, new LeaveRequest(masterNode), EmptyTransportResponseHandler.INSTANCE_SAME);
    }

    public void sendLeaveRequestBlocking(DiscoveryNode masterNode, DiscoveryNode node, TimeValue timeout) {
        this.transportService.submitRequest(masterNode, DISCOVERY_LEAVE_ACTION_NAME, new LeaveRequest(node), EmptyTransportResponseHandler.INSTANCE_SAME).txGet(timeout.millis(), TimeUnit.MILLISECONDS);
    }

    public void sendJoinRequestBlocking(DiscoveryNode masterNode, DiscoveryNode node, TimeValue timeout) {
        this.transportService.submitRequest(masterNode, DISCOVERY_JOIN_ACTION_NAME, new JoinRequest(node), EmptyTransportResponseHandler.INSTANCE_SAME).txGet(timeout.millis(), TimeUnit.MILLISECONDS);
    }

    public void sendValidateJoinRequestBlocking(DiscoveryNode node, ClusterState state, TimeValue timeout) {
        this.transportService.submitRequest(node, DISCOVERY_JOIN_VALIDATE_ACTION_NAME, new ValidateJoinRequest(state), EmptyTransportResponseHandler.INSTANCE_SAME).txGet(timeout.millis(), TimeUnit.MILLISECONDS);
    }

    static void ensureIndexCompatibility(Version nodeVersion, MetaData metaData) {
        Version supportedIndexVersion = nodeVersion.minimumIndexCompatibilityVersion();
        for (IndexMetaData idxMetaData : metaData) {
            if (idxMetaData.getCreationVersion().after(nodeVersion)) {
                throw new IllegalStateException("index " + idxMetaData.getIndex() + " version not supported: " + idxMetaData.getCreationVersion() + " the node version is: " + nodeVersion);
            }
            if (!idxMetaData.getCreationVersion().before(supportedIndexVersion)) continue;
            throw new IllegalStateException("index " + idxMetaData.getIndex() + " version not supported: " + idxMetaData.getCreationVersion() + " minimum compatible index version is: " + supportedIndexVersion);
        }
    }

    static void ensureNodesCompatibility(Version joiningNodeVersion, DiscoveryNodes currentNodes) {
        Version minNodeVersion = currentNodes.getMinNodeVersion();
        Version maxNodeVersion = currentNodes.getMaxNodeVersion();
        MembershipAction.ensureNodesCompatibility(joiningNodeVersion, minNodeVersion, maxNodeVersion);
    }

    static void ensureNodesCompatibility(Version joiningNodeVersion, Version minClusterNodeVersion, Version maxClusterNodeVersion) {
        assert (minClusterNodeVersion.onOrBefore(maxClusterNodeVersion)) : minClusterNodeVersion + " > " + maxClusterNodeVersion;
        if (!joiningNodeVersion.isCompatible(maxClusterNodeVersion)) {
            throw new IllegalStateException("node version [" + joiningNodeVersion + "] is not supported. The cluster contains nodes with version [" + maxClusterNodeVersion + "], which is incompatible.");
        }
        if (!joiningNodeVersion.isCompatible(minClusterNodeVersion)) {
            throw new IllegalStateException("node version [" + joiningNodeVersion + "] is not supported.The cluster contains nodes with version [" + minClusterNodeVersion + "], which is incompatible.");
        }
    }

    static void ensureMajorVersionBarrier(Version joiningNodeVersion, Version minClusterNodeVersion) {
        byte clusterMajor = minClusterNodeVersion.major;
        if (joiningNodeVersion.major < clusterMajor) {
            throw new IllegalStateException("node version [" + joiningNodeVersion + "] is not supported. All nodes in the cluster are of a higher major [" + clusterMajor + "].");
        }
    }

    private class LeaveRequestRequestHandler
    implements TransportRequestHandler<LeaveRequest> {
        private LeaveRequestRequestHandler() {
        }

        @Override
        public void messageReceived(LeaveRequest request, TransportChannel channel) throws Exception {
            MembershipAction.this.listener.onLeave(request.node);
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    public static class LeaveRequest
    extends TransportRequest {
        private DiscoveryNode node;

        public LeaveRequest() {
        }

        private LeaveRequest(DiscoveryNode node) {
            this.node = node;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.node = new DiscoveryNode(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.node.writeTo(out);
        }
    }

    static class ValidateJoinRequestRequestHandler
    implements TransportRequestHandler<ValidateJoinRequest> {
        private final Supplier<DiscoveryNode> localNodeSupplier;
        private final Collection<BiConsumer<DiscoveryNode, ClusterState>> joinValidators;

        ValidateJoinRequestRequestHandler(Supplier<DiscoveryNode> localNodeSupplier, Collection<BiConsumer<DiscoveryNode, ClusterState>> joinValidators) {
            this.localNodeSupplier = localNodeSupplier;
            this.joinValidators = joinValidators;
        }

        @Override
        public void messageReceived(ValidateJoinRequest request, TransportChannel channel) throws Exception {
            DiscoveryNode node = this.localNodeSupplier.get();
            assert (node != null) : "local node is null";
            this.joinValidators.stream().forEach(action -> action.accept(node, request.state));
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    static class ValidateJoinRequest
    extends TransportRequest {
        private ClusterState state;

        ValidateJoinRequest() {
        }

        ValidateJoinRequest(ClusterState state) {
            this.state = state;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.state = ClusterState.readFrom(in, null);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.state.writeTo(out);
        }
    }

    private class JoinRequestRequestHandler
    implements TransportRequestHandler<JoinRequest> {
        private JoinRequestRequestHandler() {
        }

        @Override
        public void messageReceived(JoinRequest request, final TransportChannel channel) throws Exception {
            MembershipAction.this.listener.onJoin(request.getNode(), new JoinCallback(){

                @Override
                public void onSuccess() {
                    try {
                        channel.sendResponse(TransportResponse.Empty.INSTANCE);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception inner) {
                        inner.addSuppressed(e);
                        logger.warn("failed to send back failure on join request", (Throwable)inner);
                    }
                }
            });
        }
    }

    public static class JoinRequest
    extends TransportRequest {
        private DiscoveryNode node;

        public DiscoveryNode getNode() {
            return this.node;
        }

        public JoinRequest() {
        }

        private JoinRequest(DiscoveryNode node) {
            this.node = node;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.node = new DiscoveryNode(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.node.writeTo(out);
        }
    }

    public static interface MembershipListener {
        public void onJoin(DiscoveryNode var1, JoinCallback var2);

        public void onLeave(DiscoveryNode var1);
    }

    public static interface JoinCallback {
        public void onSuccess();

        public void onFailure(Exception var1);
    }
}

