/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.discovery;

import java.util.EnumSet;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlock;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.ClusterSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestStatus;

public class DiscoverySettings {
    public static final int NO_MASTER_BLOCK_ID = 2;
    public static final ClusterBlock NO_MASTER_BLOCK_ALL = new ClusterBlock(2, "no master", true, true, false, RestStatus.SERVICE_UNAVAILABLE, ClusterBlockLevel.ALL);
    public static final ClusterBlock NO_MASTER_BLOCK_WRITES = new ClusterBlock(2, "no master", true, false, false, RestStatus.SERVICE_UNAVAILABLE, EnumSet.of(ClusterBlockLevel.WRITE, ClusterBlockLevel.METADATA_WRITE));
    public static final Setting<TimeValue> PUBLISH_TIMEOUT_SETTING = Setting.positiveTimeSetting("discovery.zen.publish_timeout", TimeValue.timeValueSeconds(30L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> COMMIT_TIMEOUT_SETTING = new Setting<TimeValue>("discovery.zen.commit_timeout", s -> PUBLISH_TIMEOUT_SETTING.getRaw((Settings)s), s -> TimeValue.parseTimeValue(s, TimeValue.timeValueSeconds(30L), "discovery.zen.commit_timeout"), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<ClusterBlock> NO_MASTER_BLOCK_SETTING = new Setting<ClusterBlock>("discovery.zen.no_master_block", "write", DiscoverySettings::parseNoMasterBlock, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> PUBLISH_DIFF_ENABLE_SETTING = Setting.boolSetting("discovery.zen.publish_diff.enable", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INITIAL_STATE_TIMEOUT_SETTING = Setting.positiveTimeSetting("discovery.initial_state_timeout", TimeValue.timeValueSeconds(30L), Setting.Property.NodeScope);
    private volatile ClusterBlock noMasterBlock;
    private volatile TimeValue publishTimeout;
    private volatile TimeValue commitTimeout;
    private volatile boolean publishDiff;

    public DiscoverySettings(Settings settings, ClusterSettings clusterSettings) {
        clusterSettings.addSettingsUpdateConsumer(NO_MASTER_BLOCK_SETTING, this::setNoMasterBlock);
        clusterSettings.addSettingsUpdateConsumer(PUBLISH_DIFF_ENABLE_SETTING, this::setPublishDiff);
        clusterSettings.addSettingsUpdateConsumer(COMMIT_TIMEOUT_SETTING, this::setCommitTimeout);
        clusterSettings.addSettingsUpdateConsumer(PUBLISH_TIMEOUT_SETTING, this::setPublishTimeout);
        this.noMasterBlock = NO_MASTER_BLOCK_SETTING.get(settings);
        this.publishTimeout = PUBLISH_TIMEOUT_SETTING.get(settings);
        this.commitTimeout = COMMIT_TIMEOUT_SETTING.get(settings);
        this.publishDiff = PUBLISH_DIFF_ENABLE_SETTING.get(settings);
    }

    public TimeValue getPublishTimeout() {
        return this.publishTimeout;
    }

    public TimeValue getCommitTimeout() {
        return this.commitTimeout;
    }

    public ClusterBlock getNoMasterBlock() {
        return this.noMasterBlock;
    }

    private void setNoMasterBlock(ClusterBlock noMasterBlock) {
        this.noMasterBlock = noMasterBlock;
    }

    private void setPublishDiff(boolean publishDiff) {
        this.publishDiff = publishDiff;
    }

    private void setPublishTimeout(TimeValue publishTimeout) {
        this.publishTimeout = publishTimeout;
    }

    private void setCommitTimeout(TimeValue commitTimeout) {
        this.commitTimeout = commitTimeout;
    }

    public boolean getPublishDiff() {
        return this.publishDiff;
    }

    private static ClusterBlock parseNoMasterBlock(String value) {
        switch (value) {
            case "all": {
                return NO_MASTER_BLOCK_ALL;
            }
            case "write": {
                return NO_MASTER_BLOCK_WRITES;
            }
        }
        throw new IllegalArgumentException("invalid master block [" + value + "]");
    }
}

