/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.CheckedFunction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.ContextParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.NamedObjectNotFoundException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class NamedXContentRegistry {
    public static final NamedXContentRegistry EMPTY = new NamedXContentRegistry(Collections.emptyList());
    private final Map<Class<?>, Map<String, Entry>> registry;

    public NamedXContentRegistry(List<Entry> entries) {
        if (entries.isEmpty()) {
            this.registry = Collections.emptyMap();
            return;
        }
        entries = new ArrayList<Entry>(entries);
        entries.sort((e1, e2) -> e1.categoryClass.getName().compareTo(e2.categoryClass.getName()));
        HashMap registry = new HashMap();
        HashMap<String, Entry> parsers = null;
        Class<?> currentCategory = null;
        for (Entry entry : entries) {
            if (currentCategory != entry.categoryClass) {
                if (currentCategory != null) {
                    registry.put(currentCategory, Collections.unmodifiableMap(parsers));
                }
                parsers = new HashMap<String, Entry>();
                currentCategory = entry.categoryClass;
            }
            for (String name : entry.name.getAllNamesIncludedDeprecated()) {
                Entry old = parsers.put(name, entry);
                if (old == null) continue;
                throw new IllegalArgumentException("NamedXContent [" + currentCategory.getName() + "][" + entry.name + "] is already registered for [" + old.getClass().getName() + "], cannot register [" + entry.parser.getClass().getName() + "]");
            }
        }
        registry.put(currentCategory, Collections.unmodifiableMap(parsers));
        this.registry = Collections.unmodifiableMap(registry);
    }

    public <T, C> T parseNamedObject(Class<T> categoryClass, String name, XContentParser parser, C context) throws IOException {
        Map<String, Entry> parsers = this.registry.get(categoryClass);
        if (parsers == null) {
            if (this.registry.isEmpty()) {
                throw new NamedObjectNotFoundException("named objects are not supported for this parser");
            }
            throw new NamedObjectNotFoundException("unknown named object category [" + categoryClass.getName() + "]");
        }
        Entry entry = parsers.get(name);
        if (entry == null) {
            throw new NamedObjectNotFoundException(parser.getTokenLocation(), "unable to parse " + categoryClass.getSimpleName() + " with name [" + name + "]: parser not found");
        }
        if (!entry.name.match(name, parser.getDeprecationHandler())) {
            throw new NamedObjectNotFoundException(parser.getTokenLocation(), "unable to parse " + categoryClass.getSimpleName() + " with name [" + name + "]: parser didn't match");
        }
        return categoryClass.cast(entry.parser.parse(parser, context));
    }

    public static class Entry {
        public final Class<?> categoryClass;
        public final ParseField name;
        private final ContextParser<Object, ?> parser;

        public <T> Entry(Class<T> categoryClass, ParseField name, CheckedFunction<XContentParser, ? extends T, IOException> parser) {
            this.categoryClass = Objects.requireNonNull(categoryClass);
            this.name = Objects.requireNonNull(name);
            this.parser = Objects.requireNonNull((p, c) -> parser.apply(p));
        }

        public <T> Entry(Class<T> categoryClass, ParseField name, ContextParser<Object, ? extends T> parser) {
            this.categoryClass = Objects.requireNonNull(categoryClass);
            this.name = Objects.requireNonNull(name);
            this.parser = Objects.requireNonNull(parser);
        }
    }
}

