/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent;

import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.DeprecationHandler;
import org.apache.logging.log4j.LogManager;

public class LoggingDeprecationHandler
implements DeprecationHandler {
    public static LoggingDeprecationHandler INSTANCE = new LoggingDeprecationHandler();
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(ParseField.class));

    private LoggingDeprecationHandler() {
    }

    @Override
    public void usedDeprecatedName(String usedName, String modernName) {
        DEPRECATION_LOGGER.deprecated("Deprecated field [{}] used, expected [{}] instead", usedName, modernName);
    }

    @Override
    public void usedDeprecatedField(String usedName, String replacedWith) {
        DEPRECATION_LOGGER.deprecated("Deprecated field [{}] used, replaced by [{}]", usedName, replacedWith);
    }

    @Override
    public void deprecated(String message, Object ... params) {
        DEPRECATION_LOGGER.deprecated(message, params);
    }
}

