/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.transport;

import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;

public class NetworkExceptionHelper {
    public static boolean isConnectException(Throwable e) {
        return e instanceof ConnectException;
    }

    public static boolean isCloseConnectionException(Throwable e) {
        if (e instanceof ClosedChannelException) {
            return true;
        }
        if (e.getMessage() != null) {
            if (e.getMessage().contains("Connection reset")) {
                return true;
            }
            if (e.getMessage().contains("connection was aborted")) {
                return true;
            }
            if (e.getMessage().contains("forcibly closed")) {
                return true;
            }
            if (e.getMessage().contains("Broken pipe")) {
                return true;
            }
            if (e.getMessage().contains("Connection timed out")) {
                return true;
            }
            if (e.getMessage().equals("Socket is closed")) {
                return true;
            }
            if (e.getMessage().equals("Socket closed")) {
                return true;
            }
        }
        return false;
    }
}

