/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.logging;

import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.logging.PrefixLogger;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.CollectionUtils;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.Index;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class Loggers {
    public static final String SPACE = " ";
    public static final Setting<Level> LOG_DEFAULT_LEVEL_SETTING = new Setting<Level>("logger.level", Level.INFO.name(), Level::valueOf, Setting.Property.NodeScope);
    public static final Setting.AffixSetting<Level> LOG_LEVEL_SETTING = Setting.prefixKeySetting("logger.", key -> new Setting<Level>((String)key, Level.INFO.name(), Level::valueOf, Setting.Property.Dynamic, Setting.Property.NodeScope));

    public static Logger getLogger(Class<?> clazz, ShardId shardId, String ... prefixes) {
        return Loggers.getLogger(clazz, shardId.getIndex(), CollectionUtils.asArrayList(Integer.toString(shardId.id()), prefixes).toArray(new String[0]));
    }

    public static Logger getLogger(String loggerName, ShardId shardId) {
        String prefix = Loggers.formatPrefix(shardId.getIndexName(), Integer.toString(shardId.id()));
        return new PrefixLogger(LogManager.getLogger((String)loggerName), prefix);
    }

    public static Logger getLogger(Class<?> clazz, Index index, String ... prefixes) {
        return Loggers.getLogger(clazz, CollectionUtils.asArrayList(SPACE, index.getName(), prefixes).toArray(new String[0]));
    }

    public static Logger getLogger(Class<?> clazz, String ... prefixes) {
        return new PrefixLogger(LogManager.getLogger(clazz), Loggers.formatPrefix(prefixes));
    }

    public static Logger getLogger(Logger parentLogger, String s) {
        Logger inner = LogManager.getLogger((String)(parentLogger.getName() + s));
        if (parentLogger instanceof PrefixLogger) {
            return new PrefixLogger(inner, ((PrefixLogger)parentLogger).prefix());
        }
        return inner;
    }

    private static String formatPrefix(String ... prefixes) {
        String prefix = null;
        if (prefixes != null && prefixes.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String prefixX : prefixes) {
                if (prefixX == null) continue;
                if (prefixX.equals(SPACE)) {
                    sb.append(SPACE);
                    continue;
                }
                sb.append("[").append(prefixX).append("]");
            }
            if (sb.length() > 0) {
                prefix = sb.toString();
            }
        }
        return prefix;
    }

    public static void setLevel(Logger logger, String level) {
        Level l = level == null ? null : Level.valueOf((String)level);
        Loggers.setLevel(logger, l);
    }

    public static void setLevel(Logger logger, Level level) {
        LoggerContext ctx;
        if (!"".equals(logger.getName())) {
            Configurator.setLevel((String)logger.getName(), (Level)level);
        } else {
            ctx = LoggerContext.getContext((boolean)false);
            Configuration config = ctx.getConfiguration();
            LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
            loggerConfig.setLevel(level);
            ctx.updateLoggers();
        }
        ctx = LoggerContext.getContext((boolean)false);
        for (LoggerConfig loggerConfig : ctx.getConfiguration().getLoggers().values()) {
            if (!"".equals(logger.getName()) && !loggerConfig.getName().startsWith(logger.getName() + ".")) continue;
            Configurator.setLevel((String)loggerConfig.getName(), (Level)level);
        }
    }

    public static void addAppender(Logger logger, Appender appender) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        config.addAppender(appender);
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        if (!logger.getName().equals(loggerConfig.getName())) {
            loggerConfig = new LoggerConfig(logger.getName(), logger.getLevel(), true);
            config.addLogger(logger.getName(), loggerConfig);
        }
        loggerConfig.addAppender(appender, null, null);
        ctx.updateLoggers();
    }

    public static void removeAppender(Logger logger, Appender appender) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        if (!logger.getName().equals(loggerConfig.getName())) {
            loggerConfig = new LoggerConfig(logger.getName(), logger.getLevel(), true);
            config.addLogger(logger.getName(), loggerConfig);
        }
        loggerConfig.removeAppender(appender.getName());
        ctx.updateLoggers();
    }

    public static Appender findAppender(Logger logger, Class<? extends Appender> clazz) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        for (Map.Entry entry : loggerConfig.getAppenders().entrySet()) {
            if (!((Appender)entry.getValue()).getClass().equals(clazz)) continue;
            return (Appender)entry.getValue();
        }
        return null;
    }
}

