/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.ConfigurationException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.EncounterImpl;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.InjectorImpl;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.MembersInjectorImpl;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.SingleFieldInjector;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.SingleMemberInjector;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.SingleMethodInjector;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.TypeLiteral;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.internal.Errors;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.internal.ErrorsException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.internal.FailableCache;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.spi.InjectionPoint;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.spi.TypeListenerBinding;

class MembersInjectorStore {
    private final InjectorImpl injector;
    private final List<TypeListenerBinding> typeListenerBindings;
    private final FailableCache<TypeLiteral<?>, MembersInjectorImpl<?>> cache = new FailableCache<TypeLiteral<?>, MembersInjectorImpl<?>>(){

        @Override
        protected MembersInjectorImpl<?> create(TypeLiteral<?> type, Errors errors) throws ErrorsException {
            return MembersInjectorStore.this.createWithListeners(type, errors);
        }
    };

    MembersInjectorStore(InjectorImpl injector, List<TypeListenerBinding> typeListenerBindings) {
        this.injector = injector;
        this.typeListenerBindings = Collections.unmodifiableList(typeListenerBindings);
    }

    public boolean hasTypeListeners() {
        return !this.typeListenerBindings.isEmpty();
    }

    public <T> MembersInjectorImpl<T> get(TypeLiteral<T> key, Errors errors) throws ErrorsException {
        return this.cache.get(key, errors);
    }

    private <T> MembersInjectorImpl<T> createWithListeners(TypeLiteral<T> type, Errors errors) throws ErrorsException {
        Set injectionPoints;
        int numErrorsBefore = errors.size();
        try {
            injectionPoints = InjectionPoint.forInstanceMethodsAndFields(type);
        }
        catch (ConfigurationException e) {
            errors.merge(e.getErrorMessages());
            injectionPoints = (Set)e.getPartialValue();
        }
        List<SingleMemberInjector> injectors = this.getInjectors(injectionPoints, errors);
        errors.throwIfNewErrors(numErrorsBefore);
        EncounterImpl encounter = new EncounterImpl(errors, this.injector.lookups);
        for (TypeListenerBinding typeListener : this.typeListenerBindings) {
            if (!typeListener.getTypeMatcher().matches(type)) continue;
            try {
                typeListener.getListener().hear(type, encounter);
            }
            catch (RuntimeException e) {
                errors.errorNotifyingTypeListener(typeListener, type, e);
            }
        }
        encounter.invalidate();
        errors.throwIfNewErrors(numErrorsBefore);
        return new MembersInjectorImpl<T>(this.injector, type, encounter, injectors);
    }

    List<SingleMemberInjector> getInjectors(Set<InjectionPoint> injectionPoints, Errors errors) {
        ArrayList<SingleFieldInjector> injectors = new ArrayList<SingleFieldInjector>();
        for (InjectionPoint injectionPoint : injectionPoints) {
            try {
                Errors errorsForMember = injectionPoint.isOptional() ? new Errors(injectionPoint) : errors.withSource(injectionPoint);
                SingleMemberInjector injector = injectionPoint.getMember() instanceof Field ? new SingleFieldInjector(this.injector, injectionPoint, errorsForMember) : new SingleMethodInjector(this.injector, injectionPoint, errorsForMember);
                injectors.add((SingleFieldInjector)injector);
            }
            catch (ErrorsException errorsException) {}
        }
        return Collections.unmodifiableList(injectors);
    }
}

