/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.Diff;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.Diffable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.io.stream.StreamOutput;

public class DiffableStringMap
extends AbstractMap<String, String>
implements Diffable<DiffableStringMap> {
    private final Map<String, String> innerMap;

    DiffableStringMap(Map<String, String> map) {
        this.innerMap = Collections.unmodifiableMap(map);
    }

    DiffableStringMap(StreamInput in) throws IOException {
        this(in.readMap());
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.innerMap.entrySet();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.innerMap);
    }

    @Override
    public Diff<DiffableStringMap> diff(DiffableStringMap previousState) {
        return new DiffableStringMapDiff(previousState, this);
    }

    public static Diff<DiffableStringMap> readDiffFrom(StreamInput in) throws IOException {
        return new DiffableStringMapDiff(in);
    }

    public static class DiffableStringMapDiff
    implements Diff<DiffableStringMap> {
        private final List<String> deletes;
        private final Map<String, String> upserts;

        private DiffableStringMapDiff(DiffableStringMap before, DiffableStringMap after) {
            ArrayList<String> tempDeletes = new ArrayList<String>();
            HashMap<String, String> tempUpserts = new HashMap<String, String>();
            for (String string : before.keySet()) {
                if (after.containsKey(string)) continue;
                tempDeletes.add(string);
            }
            for (Map.Entry entry : after.entrySet()) {
                String beforePart = (String)before.get(entry.getKey());
                if (beforePart == null) {
                    tempUpserts.put((String)entry.getKey(), (String)entry.getValue());
                    continue;
                }
                if (((String)entry.getValue()).equals(beforePart)) continue;
                tempUpserts.put((String)entry.getKey(), (String)entry.getValue());
            }
            this.deletes = tempDeletes;
            this.upserts = tempUpserts;
        }

        private DiffableStringMapDiff(StreamInput in) throws IOException {
            this.deletes = new ArrayList<String>();
            this.upserts = new HashMap<String, String>();
            int deletesCount = in.readVInt();
            for (int i = 0; i < deletesCount; ++i) {
                this.deletes.add(in.readString());
            }
            int upsertsCount = in.readVInt();
            for (int i = 0; i < upsertsCount; ++i) {
                String key = in.readString();
                String newValue = in.readString();
                this.upserts.put(key, newValue);
            }
        }

        public List<String> getDeletes() {
            return this.deletes;
        }

        public Map<String, Diff<String>> getDiffs() {
            return Collections.emptyMap();
        }

        public Map<String, String> getUpserts() {
            return this.upserts;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.deletes.size());
            for (String string : this.deletes) {
                out.writeString(string);
            }
            out.writeVInt(this.upserts.size());
            for (Map.Entry entry : this.upserts.entrySet()) {
                out.writeString((String)entry.getKey());
                out.writeString((String)entry.getValue());
            }
        }

        @Override
        public DiffableStringMap apply(DiffableStringMap part) {
            HashMap<String, String> builder = new HashMap<String, String>(part.innerMap);
            List<String> deletes = this.getDeletes();
            for (String string : deletes) {
                builder.remove(string);
            }
            assert (this.getDiffs().size() == 0) : "there should never be diffs for DiffableStringMap";
            for (Map.Entry entry : this.upserts.entrySet()) {
                builder.put((String)entry.getKey(), (String)entry.getValue());
            }
            return new DiffableStringMap(builder);
        }
    }
}

