/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.watcher;

import java.util.Locale;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.Validatable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.ValidationException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.watcher.PutWatchRequest;

public class AckWatchRequest
implements Validatable {
    private final String watchId;
    private final String[] actionIds;

    public AckWatchRequest(String watchId, String ... actionIds) {
        this.validateIds(watchId, actionIds);
        this.watchId = watchId;
        this.actionIds = actionIds;
    }

    private void validateIds(String watchId, String ... actionIds) {
        ValidationException exception = new ValidationException();
        if (watchId == null) {
            exception.addValidationError("watch id is missing");
        } else if (!PutWatchRequest.isValidId(watchId)) {
            exception.addValidationError("watch id contains whitespace");
        }
        if (actionIds != null) {
            for (String actionId : actionIds) {
                if (actionId == null) {
                    exception.addValidationError(String.format(Locale.ROOT, "action id may not be null", new Object[0]));
                    continue;
                }
                if (PutWatchRequest.isValidId(actionId)) continue;
                exception.addValidationError(String.format(Locale.ROOT, "action id [%s] contains whitespace", actionId));
            }
        }
        if (!exception.validationErrors().isEmpty()) {
            throw exception;
        }
    }

    public String getWatchId() {
        return this.watchId;
    }

    public String[] getActionIds() {
        return this.actionIds;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ack [").append(this.watchId).append("]");
        if (this.actionIds.length > 0) {
            sb.append("[");
            for (int i = 0; i < this.actionIds.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.actionIds[i]);
            }
            sb.append("]");
        }
        return sb.toString();
    }
}

