/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indices;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.MappingMetaData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParserUtils;

public class GetMappingsResponse {
    static final ParseField MAPPINGS = new ParseField("mappings", new String[0]);
    private Map<String, MappingMetaData> mappings;

    public GetMappingsResponse(Map<String, MappingMetaData> mappings) {
        this.mappings = mappings;
    }

    public Map<String, MappingMetaData> mappings() {
        return this.mappings;
    }

    public static GetMappingsResponse fromXContent(XContentParser parser) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken(parser.currentToken(), XContentParser.Token.START_OBJECT, parser::getTokenLocation);
        Map<String, Object> parts = parser.map();
        HashMap<String, MappingMetaData> mappings = new HashMap<String, MappingMetaData>();
        for (Map.Entry<String, Object> entry : parts.entrySet()) {
            String indexName = entry.getKey();
            assert (entry.getValue() instanceof Map) : "expected a map as type mapping, but got: " + entry.getValue().getClass();
            Map fieldMappings = (Map)((Map)entry.getValue()).get(MAPPINGS.getPreferredName());
            mappings.put(indexName, new MappingMetaData("_doc", fieldMappings));
        }
        return new GetMappingsResponse(mappings);
    }
}

