/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.Header;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.HttpEntity;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.HttpHost;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.HttpResponse;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.RequestLine;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.StatusLine;

public class Response {
    private final RequestLine requestLine;
    private final HttpHost host;
    private final HttpResponse response;
    private static final Pattern WARNING_HEADER_PATTERN = Pattern.compile("299 Elasticsearch-\\d+\\.\\d+\\.\\d+(?:-(?:alpha|beta|rc)\\d+)?(?:-SNAPSHOT)?-(?:[a-f0-9]{7}|Unknown) \"((?:\t| |!|[\\x23-\\x5B]|[\\x5D-\\x7E]|[\\x80-\\xFF]|\\\\|\\\\\")*)\"( \"(?:Mon|Tue|Wed|Thu|Fri|Sat|Sun), \\d{2} (?:Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) \\d{4} \\d{2}:\\d{2}:\\d{2} GMT\")?");
    private static final Pattern WARNING_HEADER_DATE_PATTERN = Pattern.compile("^ \"(?>Mon|Tue|Wed|Thu|Fri|Sat|Sun), \\d{2} (?>Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) \\d{4} \\d{2}:\\d{2}:\\d{2} GMT\"$");
    private static final int WARNING_HEADER_DATE_LENGTH = 32;

    Response(RequestLine requestLine, HttpHost host, HttpResponse response) {
        Objects.requireNonNull(requestLine, "requestLine cannot be null");
        Objects.requireNonNull(host, "host cannot be null");
        Objects.requireNonNull(response, "response cannot be null");
        this.requestLine = requestLine;
        this.host = host;
        this.response = response;
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public HttpHost getHost() {
        return this.host;
    }

    public StatusLine getStatusLine() {
        return this.response.getStatusLine();
    }

    public Header[] getHeaders() {
        return this.response.getAllHeaders();
    }

    public String getHeader(String name) {
        Header header = this.response.getFirstHeader(name);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    public HttpEntity getEntity() {
        return this.response.getEntity();
    }

    private static boolean matchWarningHeaderPatternByPrefix(String s) {
        return s.startsWith("299 Elasticsearch-");
    }

    private static String extractWarningValueFromWarningHeader(String s) {
        String possibleDateString;
        Matcher matcher;
        String warningHeader = s;
        if (s.length() > 32 && (matcher = WARNING_HEADER_DATE_PATTERN.matcher(possibleDateString = s.substring(s.length() - 32))).matches()) {
            warningHeader = warningHeader.substring(0, s.length() - 32);
        }
        int firstQuote = warningHeader.indexOf(34);
        int lastQuote = warningHeader.length() - 1;
        String warningValue = warningHeader.substring(firstQuote + 1, lastQuote);
        assert (Response.assertWarningValue(s, warningValue));
        return warningValue;
    }

    private static boolean assertWarningValue(String s, String warningValue) {
        Matcher matcher = WARNING_HEADER_PATTERN.matcher(s);
        boolean matches = matcher.matches();
        assert (matches);
        return matcher.group(1).equals(warningValue);
    }

    public List<String> getWarnings() {
        ArrayList<String> warnings = new ArrayList<String>();
        for (Header header : this.response.getHeaders("Warning")) {
            String warning = header.getValue();
            if (Response.matchWarningHeaderPatternByPrefix(warning)) {
                warnings.add(Response.extractWarningValueFromWarningHeader(warning));
                continue;
            }
            warnings.add(warning);
        }
        return warnings;
    }

    public boolean hasWarnings() {
        Header[] warnings = this.response.getHeaders("Warning");
        return warnings != null && warnings.length > 0;
    }

    HttpResponse getHttpResponse() {
        return this.response;
    }

    public String toString() {
        return "Response{requestLine=" + this.requestLine + ", host=" + this.host + ", response=" + this.response.getStatusLine() + '}';
    }
}

