/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client;

import java.io.IOException;
import java.util.Locale;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.analyze.AnalyzeRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.flush.SyncedFlushRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.shrink.ResizeType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.ActiveShardCount;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.Request;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.RequestConverters;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indices.CreateIndexRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indices.FreezeIndexRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indices.GetFieldMappingsRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indices.GetIndexRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indices.GetIndexTemplatesRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indices.GetMappingsRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indices.IndexTemplatesExistRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indices.PutIndexTemplateRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indices.PutMappingRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indices.UnfreezeIndexRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indices.rollover.RolloverRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;

final class IndicesRequestConverters {
    private IndicesRequestConverters() {
    }

    static Request deleteIndex(DeleteIndexRequest deleteIndexRequest) {
        String endpoint = RequestConverters.endpoint(deleteIndexRequest.indices());
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withTimeout(deleteIndexRequest.timeout());
        parameters.withMasterTimeout(deleteIndexRequest.masterNodeTimeout());
        parameters.withIndicesOptions(deleteIndexRequest.indicesOptions());
        return request;
    }

    static Request openIndex(OpenIndexRequest openIndexRequest) {
        String endpoint = RequestConverters.endpoint(openIndexRequest.indices(), "_open");
        Request request = new Request("POST", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withTimeout(openIndexRequest.timeout());
        parameters.withMasterTimeout(openIndexRequest.masterNodeTimeout());
        parameters.withWaitForActiveShards(openIndexRequest.waitForActiveShards(), ActiveShardCount.NONE);
        parameters.withIndicesOptions(openIndexRequest.indicesOptions());
        return request;
    }

    static Request closeIndex(CloseIndexRequest closeIndexRequest) {
        String endpoint = RequestConverters.endpoint(closeIndexRequest.indices(), "_close");
        Request request = new Request("POST", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withTimeout(closeIndexRequest.timeout());
        parameters.withMasterTimeout(closeIndexRequest.masterNodeTimeout());
        parameters.withIndicesOptions(closeIndexRequest.indicesOptions());
        return request;
    }

    static Request createIndex(CreateIndexRequest createIndexRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPart(createIndexRequest.index()).build();
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withTimeout(createIndexRequest.timeout());
        parameters.withMasterTimeout(createIndexRequest.masterNodeTimeout());
        parameters.withWaitForActiveShards(createIndexRequest.waitForActiveShards(), ActiveShardCount.DEFAULT);
        parameters.putParam("include_type_name", "false");
        request.setEntity(RequestConverters.createEntity(createIndexRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request createIndex(org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.create.CreateIndexRequest createIndexRequest) throws IOException {
        String endpoint = RequestConverters.endpoint(createIndexRequest.indices());
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withTimeout(createIndexRequest.timeout());
        parameters.withMasterTimeout(createIndexRequest.masterNodeTimeout());
        parameters.withWaitForActiveShards(createIndexRequest.waitForActiveShards(), ActiveShardCount.DEFAULT);
        parameters.putParam("include_type_name", "true");
        request.setEntity(RequestConverters.createEntity(createIndexRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request updateAliases(IndicesAliasesRequest indicesAliasesRequest) throws IOException {
        Request request = new Request("POST", "/_aliases");
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withTimeout(indicesAliasesRequest.timeout());
        parameters.withMasterTimeout(indicesAliasesRequest.masterNodeTimeout());
        request.setEntity(RequestConverters.createEntity(indicesAliasesRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request putMapping(PutMappingRequest putMappingRequest) throws IOException {
        Request request = new Request("PUT", RequestConverters.endpoint(putMappingRequest.indices(), "_mapping"));
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withTimeout(putMappingRequest.timeout());
        parameters.withMasterTimeout(putMappingRequest.masterNodeTimeout());
        parameters.putParam("include_type_name", "false");
        request.setEntity(RequestConverters.createEntity(putMappingRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    @Deprecated
    static Request putMapping(org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest putMappingRequest) throws IOException {
        if (putMappingRequest.getConcreteIndex() != null) {
            throw new IllegalArgumentException("concreteIndex cannot be set on PutMapping requests made over the REST API");
        }
        Request request = new Request("PUT", RequestConverters.endpoint(putMappingRequest.indices(), "_mapping", putMappingRequest.type()));
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withTimeout(putMappingRequest.timeout());
        parameters.withMasterTimeout(putMappingRequest.masterNodeTimeout());
        parameters.putParam("include_type_name", "true");
        request.setEntity(RequestConverters.createEntity(putMappingRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request getMappings(GetMappingsRequest getMappingsRequest) {
        String[] indices = getMappingsRequest.indices() == null ? Strings.EMPTY_ARRAY : getMappingsRequest.indices();
        Request request = new Request("GET", RequestConverters.endpoint(indices, "_mapping"));
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withMasterTimeout(getMappingsRequest.masterNodeTimeout());
        parameters.withIndicesOptions(getMappingsRequest.indicesOptions());
        parameters.withLocal(getMappingsRequest.local());
        parameters.putParam("include_type_name", "false");
        return request;
    }

    @Deprecated
    static Request getMappings(org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest getMappingsRequest) {
        String[] indices = getMappingsRequest.indices() == null ? Strings.EMPTY_ARRAY : getMappingsRequest.indices();
        String[] types = getMappingsRequest.types() == null ? Strings.EMPTY_ARRAY : getMappingsRequest.types();
        Request request = new Request("GET", RequestConverters.endpoint(indices, "_mapping", types));
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withMasterTimeout(getMappingsRequest.masterNodeTimeout());
        parameters.withIndicesOptions(getMappingsRequest.indicesOptions());
        parameters.withLocal(getMappingsRequest.local());
        parameters.putParam("include_type_name", "true");
        return request;
    }

    static Request getFieldMapping(GetFieldMappingsRequest getFieldMappingsRequest) {
        String[] indices = getFieldMappingsRequest.indices() == null ? Strings.EMPTY_ARRAY : getFieldMappingsRequest.indices();
        String[] fields = getFieldMappingsRequest.fields() == null ? Strings.EMPTY_ARRAY : getFieldMappingsRequest.fields();
        String endpoint = new RequestConverters.EndpointBuilder().addCommaSeparatedPathParts(indices).addPathPartAsIs("_mapping").addPathPartAsIs("field").addCommaSeparatedPathParts(fields).build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withIndicesOptions(getFieldMappingsRequest.indicesOptions());
        parameters.withIncludeDefaults(getFieldMappingsRequest.includeDefaults());
        parameters.withLocal(getFieldMappingsRequest.local());
        parameters.putParam("include_type_name", "false");
        return request;
    }

    @Deprecated
    static Request getFieldMapping(org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequest getFieldMappingsRequest) {
        String[] indices = getFieldMappingsRequest.indices() == null ? Strings.EMPTY_ARRAY : getFieldMappingsRequest.indices();
        String[] types = getFieldMappingsRequest.types() == null ? Strings.EMPTY_ARRAY : getFieldMappingsRequest.types();
        String[] fields = getFieldMappingsRequest.fields() == null ? Strings.EMPTY_ARRAY : getFieldMappingsRequest.fields();
        String endpoint = new RequestConverters.EndpointBuilder().addCommaSeparatedPathParts(indices).addPathPartAsIs("_mapping").addCommaSeparatedPathParts(types).addPathPartAsIs("field").addCommaSeparatedPathParts(fields).build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withIndicesOptions(getFieldMappingsRequest.indicesOptions());
        parameters.withIncludeDefaults(getFieldMappingsRequest.includeDefaults());
        parameters.withLocal(getFieldMappingsRequest.local());
        parameters.putParam("include_type_name", "true");
        return request;
    }

    static Request refresh(RefreshRequest refreshRequest) {
        String[] indices = refreshRequest.indices() == null ? Strings.EMPTY_ARRAY : refreshRequest.indices();
        Request request = new Request("POST", RequestConverters.endpoint(indices, "_refresh"));
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withIndicesOptions(refreshRequest.indicesOptions());
        return request;
    }

    static Request flush(FlushRequest flushRequest) {
        String[] indices = flushRequest.indices() == null ? Strings.EMPTY_ARRAY : flushRequest.indices();
        Request request = new Request("POST", RequestConverters.endpoint(indices, "_flush"));
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withIndicesOptions(flushRequest.indicesOptions());
        parameters.putParam("wait_if_ongoing", Boolean.toString(flushRequest.waitIfOngoing()));
        parameters.putParam("force", Boolean.toString(flushRequest.force()));
        return request;
    }

    static Request flushSynced(SyncedFlushRequest syncedFlushRequest) {
        String[] indices = syncedFlushRequest.indices() == null ? Strings.EMPTY_ARRAY : syncedFlushRequest.indices();
        Request request = new Request("POST", RequestConverters.endpoint(indices, "_flush/synced"));
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withIndicesOptions(syncedFlushRequest.indicesOptions());
        return request;
    }

    static Request forceMerge(ForceMergeRequest forceMergeRequest) {
        String[] indices = forceMergeRequest.indices() == null ? Strings.EMPTY_ARRAY : forceMergeRequest.indices();
        Request request = new Request("POST", RequestConverters.endpoint(indices, "_forcemerge"));
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withIndicesOptions(forceMergeRequest.indicesOptions());
        parameters.putParam("max_num_segments", Integer.toString(forceMergeRequest.maxNumSegments()));
        parameters.putParam("only_expunge_deletes", Boolean.toString(forceMergeRequest.onlyExpungeDeletes()));
        parameters.putParam("flush", Boolean.toString(forceMergeRequest.flush()));
        return request;
    }

    static Request clearCache(ClearIndicesCacheRequest clearIndicesCacheRequest) {
        String[] indices = clearIndicesCacheRequest.indices() == null ? Strings.EMPTY_ARRAY : clearIndicesCacheRequest.indices();
        Request request = new Request("POST", RequestConverters.endpoint(indices, "_cache/clear"));
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withIndicesOptions(clearIndicesCacheRequest.indicesOptions());
        parameters.putParam("query", Boolean.toString(clearIndicesCacheRequest.queryCache()));
        parameters.putParam("fielddata", Boolean.toString(clearIndicesCacheRequest.fieldDataCache()));
        parameters.putParam("request", Boolean.toString(clearIndicesCacheRequest.requestCache()));
        parameters.putParam("fields", String.join((CharSequence)",", clearIndicesCacheRequest.fields()));
        return request;
    }

    static Request existsAlias(GetAliasesRequest getAliasesRequest) {
        if (!(getAliasesRequest.indices() != null && getAliasesRequest.indices().length != 0 || getAliasesRequest.aliases() != null && getAliasesRequest.aliases().length != 0)) {
            throw new IllegalArgumentException("existsAlias requires at least an alias or an index");
        }
        String[] indices = getAliasesRequest.indices() == null ? Strings.EMPTY_ARRAY : getAliasesRequest.indices();
        String[] aliases = getAliasesRequest.aliases() == null ? Strings.EMPTY_ARRAY : getAliasesRequest.aliases();
        Request request = new Request("HEAD", RequestConverters.endpoint(indices, "_alias", aliases));
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withIndicesOptions(getAliasesRequest.indicesOptions());
        params.withLocal(getAliasesRequest.local());
        return request;
    }

    static Request split(ResizeRequest resizeRequest) throws IOException {
        if (resizeRequest.getResizeType() != ResizeType.SPLIT) {
            throw new IllegalArgumentException("Wrong resize type [" + (Object)((Object)resizeRequest.getResizeType()) + "] for indices split request");
        }
        return IndicesRequestConverters.resize(resizeRequest);
    }

    static Request shrink(ResizeRequest resizeRequest) throws IOException {
        if (resizeRequest.getResizeType() != ResizeType.SHRINK) {
            throw new IllegalArgumentException("Wrong resize type [" + (Object)((Object)resizeRequest.getResizeType()) + "] for indices shrink request");
        }
        return IndicesRequestConverters.resize(resizeRequest);
    }

    private static Request resize(ResizeRequest resizeRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPart(resizeRequest.getSourceIndex()).addPathPartAsIs("_" + resizeRequest.getResizeType().name().toLowerCase(Locale.ROOT)).addPathPart(resizeRequest.getTargetIndexRequest().index()).build();
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withTimeout(resizeRequest.timeout());
        params.withMasterTimeout(resizeRequest.masterNodeTimeout());
        params.withWaitForActiveShards(resizeRequest.getTargetIndexRequest().waitForActiveShards(), ActiveShardCount.DEFAULT);
        params.withCopySettings(resizeRequest.getCopySettings());
        request.setEntity(RequestConverters.createEntity(resizeRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request rollover(RolloverRequest rolloverRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPart(rolloverRequest.getAlias()).addPathPartAsIs("_rollover").addPathPart(rolloverRequest.getNewIndexName()).build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withTimeout(rolloverRequest.timeout());
        params.withMasterTimeout(rolloverRequest.masterNodeTimeout());
        params.withWaitForActiveShards(rolloverRequest.getCreateIndexRequest().waitForActiveShards(), ActiveShardCount.DEFAULT);
        if (rolloverRequest.isDryRun()) {
            params.putParam("dry_run", Boolean.TRUE.toString());
        }
        params.putParam("include_type_name", "false");
        request.setEntity(RequestConverters.createEntity(rolloverRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    @Deprecated
    static Request rollover(org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.rollover.RolloverRequest rolloverRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPart(rolloverRequest.getAlias()).addPathPartAsIs("_rollover").addPathPart(rolloverRequest.getNewIndexName()).build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withTimeout(rolloverRequest.timeout());
        params.withMasterTimeout(rolloverRequest.masterNodeTimeout());
        params.withWaitForActiveShards(rolloverRequest.getCreateIndexRequest().waitForActiveShards());
        if (rolloverRequest.isDryRun()) {
            params.putParam("dry_run", Boolean.TRUE.toString());
        }
        params.putParam("include_type_name", "true");
        request.setEntity(RequestConverters.createEntity(rolloverRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request getSettings(GetSettingsRequest getSettingsRequest) {
        String[] indices = getSettingsRequest.indices() == null ? Strings.EMPTY_ARRAY : getSettingsRequest.indices();
        String[] names = getSettingsRequest.names() == null ? Strings.EMPTY_ARRAY : getSettingsRequest.names();
        String endpoint = RequestConverters.endpoint(indices, "_settings", names);
        Request request = new Request("GET", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withIndicesOptions(getSettingsRequest.indicesOptions());
        params.withLocal(getSettingsRequest.local());
        params.withIncludeDefaults(getSettingsRequest.includeDefaults());
        params.withMasterTimeout(getSettingsRequest.masterNodeTimeout());
        return request;
    }

    @Deprecated
    static Request getIndex(org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.get.GetIndexRequest getIndexRequest) {
        String[] indices = getIndexRequest.indices() == null ? Strings.EMPTY_ARRAY : getIndexRequest.indices();
        String endpoint = RequestConverters.endpoint(indices);
        Request request = new Request("GET", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withIndicesOptions(getIndexRequest.indicesOptions());
        params.withLocal(getIndexRequest.local());
        params.withIncludeDefaults(getIndexRequest.includeDefaults());
        params.withHuman(getIndexRequest.humanReadable());
        params.withMasterTimeout(getIndexRequest.masterNodeTimeout());
        params.putParam("include_type_name", Boolean.TRUE.toString());
        return request;
    }

    static Request getIndex(GetIndexRequest getIndexRequest) {
        String[] indices = getIndexRequest.indices() == null ? Strings.EMPTY_ARRAY : getIndexRequest.indices();
        String endpoint = RequestConverters.endpoint(indices);
        Request request = new Request("GET", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withIndicesOptions(getIndexRequest.indicesOptions());
        params.withLocal(getIndexRequest.local());
        params.withIncludeDefaults(getIndexRequest.includeDefaults());
        params.withHuman(getIndexRequest.humanReadable());
        params.withMasterTimeout(getIndexRequest.masterNodeTimeout());
        params.putParam("include_type_name", Boolean.FALSE.toString());
        return request;
    }

    @Deprecated
    static Request indicesExist(org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.get.GetIndexRequest getIndexRequest) {
        if (getIndexRequest.indices() == null || getIndexRequest.indices().length == 0) {
            throw new IllegalArgumentException("indices are mandatory");
        }
        String endpoint = RequestConverters.endpoint(getIndexRequest.indices(), "");
        Request request = new Request("HEAD", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withLocal(getIndexRequest.local());
        params.withHuman(getIndexRequest.humanReadable());
        params.withIndicesOptions(getIndexRequest.indicesOptions());
        params.withIncludeDefaults(getIndexRequest.includeDefaults());
        params.putParam("include_type_name", Boolean.TRUE.toString());
        return request;
    }

    static Request indicesExist(GetIndexRequest getIndexRequest) {
        if (getIndexRequest.indices() == null || getIndexRequest.indices().length == 0) {
            throw new IllegalArgumentException("indices are mandatory");
        }
        String endpoint = RequestConverters.endpoint(getIndexRequest.indices(), "");
        Request request = new Request("HEAD", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withLocal(getIndexRequest.local());
        params.withHuman(getIndexRequest.humanReadable());
        params.withIndicesOptions(getIndexRequest.indicesOptions());
        params.withIncludeDefaults(getIndexRequest.includeDefaults());
        params.putParam("include_type_name", Boolean.FALSE.toString());
        return request;
    }

    static Request indexPutSettings(UpdateSettingsRequest updateSettingsRequest) throws IOException {
        String[] indices = updateSettingsRequest.indices() == null ? Strings.EMPTY_ARRAY : updateSettingsRequest.indices();
        Request request = new Request("PUT", RequestConverters.endpoint(indices, "_settings"));
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withTimeout(updateSettingsRequest.timeout());
        parameters.withMasterTimeout(updateSettingsRequest.masterNodeTimeout());
        parameters.withIndicesOptions(updateSettingsRequest.indicesOptions());
        parameters.withPreserveExisting(updateSettingsRequest.isPreserveExisting());
        request.setEntity(RequestConverters.createEntity(updateSettingsRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    @Deprecated
    static Request putTemplate(org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest putIndexTemplateRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_template").addPathPart(putIndexTemplateRequest.name()).build();
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withMasterTimeout(putIndexTemplateRequest.masterNodeTimeout());
        params.putParam("include_type_name", Boolean.TRUE.toString());
        if (putIndexTemplateRequest.create()) {
            params.putParam("create", Boolean.TRUE.toString());
        }
        if (Strings.hasText(putIndexTemplateRequest.cause())) {
            params.putParam("cause", putIndexTemplateRequest.cause());
        }
        request.setEntity(RequestConverters.createEntity(putIndexTemplateRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request putTemplate(PutIndexTemplateRequest putIndexTemplateRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_template").addPathPart(putIndexTemplateRequest.name()).build();
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withMasterTimeout(putIndexTemplateRequest.masterNodeTimeout());
        if (putIndexTemplateRequest.mappings() != null) {
            params.putParam("include_type_name", Boolean.FALSE.toString());
        }
        if (putIndexTemplateRequest.create()) {
            params.putParam("create", Boolean.TRUE.toString());
        }
        if (Strings.hasText(putIndexTemplateRequest.cause())) {
            params.putParam("cause", putIndexTemplateRequest.cause());
        }
        request.setEntity(RequestConverters.createEntity(putIndexTemplateRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request validateQuery(ValidateQueryRequest validateQueryRequest) throws IOException {
        String[] indices = validateQueryRequest.indices() == null ? Strings.EMPTY_ARRAY : validateQueryRequest.indices();
        String[] types = validateQueryRequest.types() == null || indices.length <= 0 ? Strings.EMPTY_ARRAY : validateQueryRequest.types();
        String endpoint = RequestConverters.endpoint(indices, types, "_validate/query");
        Request request = new Request("GET", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withIndicesOptions(validateQueryRequest.indicesOptions());
        params.putParam("explain", Boolean.toString(validateQueryRequest.explain()));
        params.putParam("all_shards", Boolean.toString(validateQueryRequest.allShards()));
        params.putParam("rewrite", Boolean.toString(validateQueryRequest.rewrite()));
        request.setEntity(RequestConverters.createEntity(validateQueryRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request getAlias(GetAliasesRequest getAliasesRequest) {
        String[] indices = getAliasesRequest.indices() == null ? Strings.EMPTY_ARRAY : getAliasesRequest.indices();
        String[] aliases = getAliasesRequest.aliases() == null ? Strings.EMPTY_ARRAY : getAliasesRequest.aliases();
        String endpoint = RequestConverters.endpoint(indices, "_alias", aliases);
        Request request = new Request("GET", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withIndicesOptions(getAliasesRequest.indicesOptions());
        params.withLocal(getAliasesRequest.local());
        return request;
    }

    @Deprecated
    static Request getTemplatesWithDocumentTypes(GetIndexTemplatesRequest getIndexTemplatesRequest) {
        return IndicesRequestConverters.getTemplates(getIndexTemplatesRequest, true);
    }

    static Request getTemplates(GetIndexTemplatesRequest getIndexTemplatesRequest) {
        return IndicesRequestConverters.getTemplates(getIndexTemplatesRequest, false);
    }

    private static Request getTemplates(GetIndexTemplatesRequest getIndexTemplatesRequest, boolean includeTypeName) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_template").addCommaSeparatedPathParts(getIndexTemplatesRequest.names()).build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withLocal(getIndexTemplatesRequest.isLocal());
        params.withMasterTimeout(getIndexTemplatesRequest.getMasterNodeTimeout());
        params.putParam("include_type_name", Boolean.toString(includeTypeName));
        return request;
    }

    static Request templatesExist(IndexTemplatesExistRequest indexTemplatesExistRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_template").addCommaSeparatedPathParts(indexTemplatesExistRequest.names()).build();
        Request request = new Request("HEAD", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withLocal(indexTemplatesExistRequest.isLocal());
        params.withMasterTimeout(indexTemplatesExistRequest.getMasterNodeTimeout());
        return request;
    }

    static Request analyze(AnalyzeRequest request) throws IOException {
        RequestConverters.EndpointBuilder builder = new RequestConverters.EndpointBuilder();
        String index = request.index();
        if (index != null) {
            builder.addPathPart(index);
        }
        builder.addPathPartAsIs("_analyze");
        Request req = new Request("GET", builder.build());
        req.setEntity(RequestConverters.createEntity(request, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return req;
    }

    static Request freezeIndex(FreezeIndexRequest freezeIndexRequest) {
        String endpoint = RequestConverters.endpoint(freezeIndexRequest.getIndices(), "_freeze");
        Request request = new Request("POST", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withTimeout(freezeIndexRequest.timeout());
        parameters.withMasterTimeout(freezeIndexRequest.masterNodeTimeout());
        parameters.withIndicesOptions(freezeIndexRequest.indicesOptions());
        parameters.withWaitForActiveShards(freezeIndexRequest.getWaitForActiveShards(), ActiveShardCount.DEFAULT);
        return request;
    }

    static Request unfreezeIndex(UnfreezeIndexRequest unfreezeIndexRequest) {
        String endpoint = RequestConverters.endpoint(unfreezeIndexRequest.getIndices(), "_unfreeze");
        Request request = new Request("POST", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params(request);
        parameters.withTimeout(unfreezeIndexRequest.timeout());
        parameters.withMasterTimeout(unfreezeIndexRequest.masterNodeTimeout());
        parameters.withIndicesOptions(unfreezeIndexRequest.indicesOptions());
        parameters.withWaitForActiveShards(unfreezeIndexRequest.getWaitForActiveShards(), ActiveShardCount.DEFAULT);
        return request;
    }

    static Request deleteTemplate(DeleteIndexTemplateRequest deleteIndexTemplateRequest) {
        String name = deleteIndexTemplateRequest.name();
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_template").addPathPart(name).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withMasterTimeout(deleteIndexTemplateRequest.masterNodeTimeout());
        return request;
    }
}

