/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.Request;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.RequestConverters;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indexlifecycle.DeleteLifecyclePolicyRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indexlifecycle.ExplainLifecycleRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indexlifecycle.GetLifecyclePolicyRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indexlifecycle.LifecycleManagementStatusRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indexlifecycle.PutLifecyclePolicyRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indexlifecycle.RemoveIndexLifecyclePolicyRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indexlifecycle.RetryLifecyclePolicyRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indexlifecycle.StartILMRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.indexlifecycle.StopILMRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;

final class IndexLifecycleRequestConverters {
    private IndexLifecycleRequestConverters() {
    }

    static Request getLifecyclePolicy(GetLifecyclePolicyRequest getLifecyclePolicyRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ilm/policy").addCommaSeparatedPathParts(getLifecyclePolicyRequest.getPolicyNames()).build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withMasterTimeout(getLifecyclePolicyRequest.masterNodeTimeout());
        params.withTimeout(getLifecyclePolicyRequest.timeout());
        return request;
    }

    static Request putLifecyclePolicy(PutLifecyclePolicyRequest putLifecycleRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_ilm/policy").addPathPartAsIs(putLifecycleRequest.getName()).build();
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withMasterTimeout(putLifecycleRequest.masterNodeTimeout());
        params.withTimeout(putLifecycleRequest.timeout());
        request.setEntity(RequestConverters.createEntity(putLifecycleRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request deleteLifecyclePolicy(DeleteLifecyclePolicyRequest deleteLifecyclePolicyRequest) {
        Request request = new Request("DELETE", new RequestConverters.EndpointBuilder().addPathPartAsIs("_ilm/policy").addPathPartAsIs(deleteLifecyclePolicyRequest.getLifecyclePolicy()).build());
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withMasterTimeout(deleteLifecyclePolicyRequest.masterNodeTimeout());
        params.withTimeout(deleteLifecyclePolicyRequest.timeout());
        return request;
    }

    static Request removeIndexLifecyclePolicy(RemoveIndexLifecyclePolicyRequest removePolicyRequest) {
        String[] indices = removePolicyRequest.indices() == null ? Strings.EMPTY_ARRAY : removePolicyRequest.indices().toArray(new String[0]);
        Request request = new Request("POST", new RequestConverters.EndpointBuilder().addCommaSeparatedPathParts(indices).addPathPartAsIs("_ilm", "remove").build());
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withIndicesOptions(removePolicyRequest.indicesOptions());
        params.withMasterTimeout(removePolicyRequest.masterNodeTimeout());
        return request;
    }

    static Request startILM(StartILMRequest startILMRequest) {
        Request request = new Request("POST", new RequestConverters.EndpointBuilder().addPathPartAsIs("_ilm").addPathPartAsIs("start").build());
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withMasterTimeout(startILMRequest.masterNodeTimeout());
        params.withTimeout(startILMRequest.timeout());
        return request;
    }

    static Request stopILM(StopILMRequest stopILMRequest) {
        Request request = new Request("POST", new RequestConverters.EndpointBuilder().addPathPartAsIs("_ilm").addPathPartAsIs("stop").build());
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withMasterTimeout(stopILMRequest.masterNodeTimeout());
        params.withTimeout(stopILMRequest.timeout());
        return request;
    }

    static Request lifecycleManagementStatus(LifecycleManagementStatusRequest lifecycleManagementStatusRequest) {
        Request request = new Request("GET", new RequestConverters.EndpointBuilder().addPathPartAsIs("_ilm").addPathPartAsIs("status").build());
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withMasterTimeout(lifecycleManagementStatusRequest.masterNodeTimeout());
        params.withTimeout(lifecycleManagementStatusRequest.timeout());
        return request;
    }

    static Request explainLifecycle(ExplainLifecycleRequest explainLifecycleRequest) {
        Request request = new Request("GET", new RequestConverters.EndpointBuilder().addCommaSeparatedPathParts(explainLifecycleRequest.getIndices()).addPathPartAsIs("_ilm").addPathPartAsIs("explain").build());
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withIndicesOptions(explainLifecycleRequest.indicesOptions());
        params.withMasterTimeout(explainLifecycleRequest.masterNodeTimeout());
        return request;
    }

    static Request retryLifecycle(RetryLifecyclePolicyRequest retryLifecyclePolicyRequest) {
        Request request = new Request("POST", new RequestConverters.EndpointBuilder().addCommaSeparatedPathParts(retryLifecyclePolicyRequest.getIndices()).addPathPartAsIs("_ilm").addPathPartAsIs("retry").build());
        RequestConverters.Params params = new RequestConverters.Params(request);
        params.withMasterTimeout(retryLifecyclePolicyRequest.masterNodeTimeout());
        params.withTimeout(retryLifecyclePolicyRequest.timeout());
        return request;
    }
}

