/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.termvectors;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.Fields;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.PostingsEnum;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.CollectionStatistics;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.TermStatistics;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.similarities.ClassicSimilarity;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.similarities.TFIDFSimilarity;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.PriorityQueue;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.dfs.AggregatedDfs;

public class TermVectorsFilter {
    public static final int DEFAULT_MAX_QUERY_TERMS = 25;
    public static final int DEFAULT_MIN_TERM_FREQ = 0;
    public static final int DEFAULT_MAX_TERM_FREQ = Integer.MAX_VALUE;
    public static final int DEFAULT_MIN_DOC_FREQ = 0;
    public static final int DEFAULT_MAX_DOC_FREQ = Integer.MAX_VALUE;
    public static final int DEFAULT_MIN_WORD_LENGTH = 0;
    public static final int DEFAULT_MAX_WORD_LENGTH = 0;
    private int maxNumTerms = 25;
    private int minTermFreq = 0;
    private int maxTermFreq = Integer.MAX_VALUE;
    private int minDocFreq = 0;
    private int maxDocFreq = Integer.MAX_VALUE;
    private int minWordLength = 0;
    private int maxWordLength = 0;
    private Fields fields;
    private Fields topLevelFields;
    private final Set<String> selectedFields;
    private AggregatedDfs dfs;
    private Map<Term, ScoreTerm> scoreTerms;
    private Map<String, Integer> sizes = new HashMap<String, Integer>();
    private TFIDFSimilarity similarity;

    public TermVectorsFilter(Fields termVectorsByField, Fields topLevelFields, Set<String> selectedFields, @Nullable AggregatedDfs dfs) {
        this.fields = termVectorsByField;
        this.topLevelFields = topLevelFields;
        this.selectedFields = selectedFields;
        this.dfs = dfs;
        this.scoreTerms = new HashMap<Term, ScoreTerm>();
        this.similarity = new ClassicSimilarity();
    }

    public void setSettings(TermVectorsRequest.FilterSettings settings) {
        if (settings.maxNumTerms != null) {
            this.setMaxNumTerms(settings.maxNumTerms);
        }
        if (settings.minTermFreq != null) {
            this.setMinTermFreq(settings.minTermFreq);
        }
        if (settings.maxTermFreq != null) {
            this.setMaxTermFreq(settings.maxTermFreq);
        }
        if (settings.minDocFreq != null) {
            this.setMinDocFreq(settings.minDocFreq);
        }
        if (settings.maxDocFreq != null) {
            this.setMaxDocFreq(settings.maxDocFreq);
        }
        if (settings.minWordLength != null) {
            this.setMinWordLength(settings.minWordLength);
        }
        if (settings.maxWordLength != null) {
            this.setMaxWordLength(settings.maxWordLength);
        }
    }

    public ScoreTerm getScoreTerm(Term term) {
        return this.scoreTerms.get(term);
    }

    public boolean hasScoreTerm(Term term) {
        return this.getScoreTerm(term) != null;
    }

    public long size(String fieldName) {
        return this.sizes.get(fieldName).intValue();
    }

    public int getMaxNumTerms() {
        return this.maxNumTerms;
    }

    public int getMinTermFreq() {
        return this.minTermFreq;
    }

    public int getMaxTermFreq() {
        return this.maxTermFreq;
    }

    public int getMinDocFreq() {
        return this.minDocFreq;
    }

    public int getMaxDocFreq() {
        return this.maxDocFreq;
    }

    public int getMinWordLength() {
        return this.minWordLength;
    }

    public int getMaxWordLength() {
        return this.maxWordLength;
    }

    public void setMaxNumTerms(int maxNumTerms) {
        this.maxNumTerms = maxNumTerms;
    }

    public void setMinTermFreq(int minTermFreq) {
        this.minTermFreq = minTermFreq;
    }

    public void setMaxTermFreq(int maxTermFreq) {
        this.maxTermFreq = maxTermFreq;
    }

    public void setMinDocFreq(int minDocFreq) {
        this.minDocFreq = minDocFreq;
    }

    public void setMaxDocFreq(int maxDocFreq) {
        this.maxDocFreq = maxDocFreq;
    }

    public void setMinWordLength(int minWordLength) {
        this.minWordLength = minWordLength;
    }

    public void setMaxWordLength(int maxWordLength) {
        this.maxWordLength = maxWordLength;
    }

    public void selectBestTerms() throws IOException {
        PostingsEnum docsEnum = null;
        for (String fieldName : this.fields) {
            ScoreTerm scoreTerm;
            if (this.selectedFields != null && !this.selectedFields.contains(fieldName)) continue;
            Terms terms = this.fields.terms(fieldName);
            Terms topLevelTerms = this.topLevelFields.terms(fieldName);
            if (topLevelTerms == null) {
                topLevelTerms = terms;
            }
            long numDocs = this.getDocCount(fieldName, topLevelTerms);
            ScoreTermsQueue queue = new ScoreTermsQueue(Math.min(this.maxNumTerms, (int)terms.size()));
            TermsEnum termsEnum = terms.iterator();
            TermsEnum topLevelTermsEnum = topLevelTerms.iterator();
            while (termsEnum.next() != null) {
                long docFreq;
                BytesRef termBytesRef = termsEnum.term();
                boolean foundTerm = topLevelTermsEnum.seekExact(termBytesRef);
                assert (foundTerm) : "Term: " + termBytesRef.utf8ToString() + " not found!";
                Term term = new Term(fieldName, termBytesRef);
                int freq = this.getTermFreq(termsEnum, docsEnum);
                if (this.isNoise(term.bytes().utf8ToString(), freq) || !this.isAccepted(docFreq = this.getTermStatistics(topLevelTermsEnum, term).docFreq())) continue;
                float score = this.computeScore(docFreq, freq, numDocs);
                queue.addOrUpdate(new ScoreTerm(term.field(), term.bytes().utf8ToString(), score));
            }
            int count = 0;
            while ((scoreTerm = (ScoreTerm)queue.pop()) != null) {
                this.scoreTerms.put(new Term(scoreTerm.field, scoreTerm.word), scoreTerm);
                ++count;
            }
            this.sizes.put(fieldName, count);
        }
    }

    private boolean isNoise(String word, int freq) {
        int len = word.length();
        if (this.minWordLength > 0 && len < this.minWordLength) {
            return true;
        }
        if (this.maxWordLength > 0 && len > this.maxWordLength) {
            return true;
        }
        if (this.minTermFreq > 0 && freq < this.minTermFreq) {
            return true;
        }
        return freq > this.maxTermFreq;
    }

    private boolean isAccepted(long docFreq) {
        if (this.minDocFreq > 0 && docFreq < (long)this.minDocFreq) {
            return false;
        }
        if (docFreq > (long)this.maxDocFreq) {
            return false;
        }
        return docFreq != 0L;
    }

    private long getDocCount(String fieldName, Terms topLevelTerms) throws IOException {
        if (this.dfs != null) {
            return ((CollectionStatistics)this.dfs.fieldStatistics().get((Object)fieldName)).docCount();
        }
        return topLevelTerms.getDocCount();
    }

    private TermStatistics getTermStatistics(TermsEnum termsEnum, Term term) throws IOException {
        if (this.dfs != null) {
            return (TermStatistics)this.dfs.termStatistics().get((Object)term);
        }
        return new TermStatistics(termsEnum.term(), termsEnum.docFreq(), termsEnum.totalTermFreq());
    }

    private int getTermFreq(TermsEnum termsEnum, PostingsEnum docsEnum) throws IOException {
        docsEnum = termsEnum.postings(docsEnum);
        docsEnum.nextDoc();
        return docsEnum.freq();
    }

    private float computeScore(long docFreq, int freq, long numDocs) {
        return (float)freq * this.similarity.idf(docFreq, numDocs);
    }

    private static class ScoreTermsQueue
    extends PriorityQueue<ScoreTerm> {
        private final int limit;

        ScoreTermsQueue(int maxSize) {
            super(maxSize);
            this.limit = maxSize;
        }

        @Override
        protected boolean lessThan(ScoreTerm a, ScoreTerm b) {
            return a.score < b.score;
        }

        public void addOrUpdate(ScoreTerm scoreTerm) {
            if (this.size() < this.limit) {
                this.add(scoreTerm);
            } else {
                ScoreTerm scoreTermTop = (ScoreTerm)this.top();
                if (scoreTermTop.score < scoreTerm.score) {
                    scoreTermTop.update(scoreTerm.field, scoreTerm.word, scoreTerm.score);
                    this.updateTop();
                }
            }
        }
    }

    public static final class ScoreTerm {
        public String field;
        public String word;
        public float score;

        ScoreTerm(String field, String word, float score) {
            this.field = field;
            this.word = word;
            this.score = score;
        }

        void update(String field, String word, float score) {
            this.field = field;
            this.word = word;
            this.score = score;
        }
    }
}

