/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.MultiSearchRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.MultiSearchResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.SearchRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.SearchResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.TransportSearchAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.HandledTransportAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.TransportAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.AtomicArray;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.util.concurrent.EsExecutors;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportService;

public class TransportMultiSearchAction
extends HandledTransportAction<MultiSearchRequest, MultiSearchResponse> {
    private final int availableProcessors;
    private final ClusterService clusterService;
    private final TransportAction<SearchRequest, SearchResponse> searchAction;

    @Inject
    public TransportMultiSearchAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, TransportSearchAction searchAction, ActionFilters actionFilters, IndexNameExpressionResolver resolver) {
        super(settings, "indices:data/read/msearch", threadPool, transportService, actionFilters, resolver, MultiSearchRequest::new);
        this.clusterService = clusterService;
        this.searchAction = searchAction;
        this.availableProcessors = EsExecutors.numberOfProcessors(settings);
    }

    TransportMultiSearchAction(ThreadPool threadPool, ActionFilters actionFilters, TransportService transportService, ClusterService clusterService, TransportAction<SearchRequest, SearchResponse> searchAction, IndexNameExpressionResolver resolver, int availableProcessors) {
        super(Settings.EMPTY, "indices:data/read/msearch", threadPool, transportService, actionFilters, resolver, MultiSearchRequest::new);
        this.clusterService = clusterService;
        this.searchAction = searchAction;
        this.availableProcessors = availableProcessors;
    }

    @Override
    protected void doExecute(MultiSearchRequest request, ActionListener<MultiSearchResponse> listener) {
        ClusterState clusterState = this.clusterService.state();
        clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
        int maxConcurrentSearches = request.maxConcurrentSearchRequests();
        if (maxConcurrentSearches == 0) {
            maxConcurrentSearches = TransportMultiSearchAction.defaultMaxConcurrentSearches(this.availableProcessors, clusterState);
        }
        ConcurrentLinkedQueue<SearchRequestSlot> searchRequestSlots = new ConcurrentLinkedQueue<SearchRequestSlot>();
        for (int i = 0; i < request.requests().size(); ++i) {
            SearchRequest searchRequest = request.requests().get(i);
            searchRequestSlots.add(new SearchRequestSlot(searchRequest, i));
        }
        int numRequests = request.requests().size();
        AtomicArray<MultiSearchResponse.Item> responses = new AtomicArray<MultiSearchResponse.Item>(numRequests);
        AtomicInteger responseCounter = new AtomicInteger(numRequests);
        int numConcurrentSearches = Math.min(numRequests, maxConcurrentSearches);
        for (int i = 0; i < numConcurrentSearches; ++i) {
            this.executeSearch(searchRequestSlots, responses, responseCounter, listener);
        }
    }

    static int defaultMaxConcurrentSearches(int availableProcessors, ClusterState state) {
        int numDateNodes = state.getNodes().getDataNodes().size();
        int defaultSearchThreadPoolSize = Math.min(ThreadPool.searchThreadPoolSize(availableProcessors), 10);
        return Math.max(1, numDateNodes * defaultSearchThreadPoolSize);
    }

    private void executeSearch(final Queue<SearchRequestSlot> requests, final AtomicArray<MultiSearchResponse.Item> responses, final AtomicInteger responseCounter, final ActionListener<MultiSearchResponse> listener) {
        final SearchRequestSlot request = requests.poll();
        if (request == null) {
            return;
        }
        final Thread thread = Thread.currentThread();
        this.searchAction.execute(request.request, new ActionListener<SearchResponse>(){

            @Override
            public void onResponse(SearchResponse searchResponse) {
                this.handleResponse(request.responseSlot, new MultiSearchResponse.Item(searchResponse, null));
            }

            @Override
            public void onFailure(Exception e) {
                this.handleResponse(request.responseSlot, new MultiSearchResponse.Item(null, e));
            }

            private void handleResponse(int responseSlot, MultiSearchResponse.Item item) {
                responses.set(responseSlot, item);
                if (responseCounter.decrementAndGet() == 0) {
                    assert (requests.isEmpty());
                    this.finish();
                } else if (thread == Thread.currentThread()) {
                    TransportMultiSearchAction.this.threadPool.generic().execute(() -> TransportMultiSearchAction.this.executeSearch(requests, responses, responseCounter, listener));
                } else {
                    TransportMultiSearchAction.this.executeSearch(requests, responses, responseCounter, listener);
                }
            }

            private void finish() {
                listener.onResponse(new MultiSearchResponse(responses.toArray(new MultiSearchResponse.Item[responses.length()])));
            }
        });
    }

    static final class SearchRequestSlot {
        final SearchRequest request;
        final int responseSlot;

        SearchRequestSlot(SearchRequest request, int responseSlot) {
            this.request = request;
            this.responseSlot = responseSlot;
        }
    }
}

