/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.snapshots.get;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.CollectionUtil;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlockException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.regex.Regex;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.repositories.IndexId;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.repositories.RepositoryData;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.snapshots.SnapshotId;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.snapshots.SnapshotInfo;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.snapshots.SnapshotMissingException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.snapshots.SnapshotsService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportService;

public class TransportGetSnapshotsAction
extends TransportMasterNodeAction<GetSnapshotsRequest, GetSnapshotsResponse> {
    private final SnapshotsService snapshotsService;

    @Inject
    public TransportGetSnapshotsAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, SnapshotsService snapshotsService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:admin/snapshot/get", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, GetSnapshotsRequest::new);
        this.snapshotsService = snapshotsService;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected GetSnapshotsResponse newResponse() {
        return new GetSnapshotsResponse();
    }

    @Override
    protected ClusterBlockException checkBlock(GetSnapshotsRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void masterOperation(GetSnapshotsRequest request, ClusterState state, ActionListener<GetSnapshotsResponse> listener) {
        try {
            void var9_21;
            RepositoryData repositoryData;
            String repository = request.repository();
            HashMap<String, SnapshotId> allSnapshotIds = new HashMap<String, SnapshotId>();
            ArrayList<SnapshotInfo> currentSnapshots = new ArrayList<SnapshotInfo>();
            for (SnapshotInfo snapshotInfo : this.snapshotsService.currentSnapshots(repository)) {
                SnapshotId snapshotId = snapshotInfo.snapshotId();
                allSnapshotIds.put(snapshotId.getName(), snapshotId);
                currentSnapshots.add(snapshotInfo);
            }
            if (!this.isCurrentSnapshotsOnly(request.snapshots())) {
                repositoryData = this.snapshotsService.getRepositoryData(repository);
                for (SnapshotId snapshotId : repositoryData.getAllSnapshotIds()) {
                    allSnapshotIds.put(snapshotId.getName(), snapshotId);
                }
            } else {
                repositoryData = null;
            }
            HashSet<SnapshotId> hashSet = new HashSet<SnapshotId>();
            if (this.isAllSnapshots(request.snapshots())) {
                hashSet.addAll(allSnapshotIds.values());
            } else {
                for (String snapshotOrPattern : request.snapshots()) {
                    if ("_current".equalsIgnoreCase(snapshotOrPattern)) {
                        hashSet.addAll(currentSnapshots.stream().map(SnapshotInfo::snapshotId).collect(Collectors.toList()));
                        continue;
                    }
                    if (!Regex.isSimpleMatchPattern(snapshotOrPattern)) {
                        if (allSnapshotIds.containsKey(snapshotOrPattern)) {
                            hashSet.add((SnapshotId)allSnapshotIds.get(snapshotOrPattern));
                            continue;
                        }
                        if (request.ignoreUnavailable()) continue;
                        throw new SnapshotMissingException(repository, snapshotOrPattern);
                    }
                    for (Map.Entry entry : allSnapshotIds.entrySet()) {
                        if (!Regex.simpleMatch(snapshotOrPattern, (String)entry.getKey())) continue;
                        hashSet.add((SnapshotId)entry.getValue());
                    }
                }
                if (hashSet.isEmpty() && !request.ignoreUnavailable() && !this.isCurrentSnapshotsOnly(request.snapshots())) {
                    throw new SnapshotMissingException(repository, request.snapshots()[0]);
                }
            }
            if (request.verbose()) {
                HashSet<SnapshotId> incompatibleSnapshots = repositoryData != null ? new HashSet<SnapshotId>(repositoryData.getIncompatibleSnapshotIds()) : Collections.emptySet();
                List<SnapshotInfo> list = this.snapshotsService.snapshots(repository, new ArrayList<SnapshotId>(hashSet), incompatibleSnapshots, request.ignoreUnavailable());
            } else if (repositoryData != null) {
                List<SnapshotInfo> list = this.buildSimpleSnapshotInfos(hashSet, repositoryData, currentSnapshots);
            } else {
                List list = currentSnapshots.stream().map(SnapshotInfo::basic).collect(Collectors.toList());
                CollectionUtil.timSort(list);
            }
            listener.onResponse(new GetSnapshotsResponse((List<SnapshotInfo>)var9_21));
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private boolean isAllSnapshots(String[] snapshots) {
        return snapshots.length == 0 || snapshots.length == 1 && "_all".equalsIgnoreCase(snapshots[0]);
    }

    private boolean isCurrentSnapshotsOnly(String[] snapshots) {
        return snapshots.length == 1 && "_current".equalsIgnoreCase(snapshots[0]);
    }

    private List<SnapshotInfo> buildSimpleSnapshotInfos(Set<SnapshotId> toResolve, RepositoryData repositoryData, List<SnapshotInfo> currentSnapshots) {
        ArrayList<SnapshotInfo> snapshotInfos = new ArrayList<SnapshotInfo>();
        for (SnapshotInfo snapshotInfo : currentSnapshots) {
            if (!toResolve.remove(snapshotInfo.snapshotId())) continue;
            snapshotInfos.add(snapshotInfo.basic());
        }
        HashMap<SnapshotId, List> snapshotsToIndices = new HashMap<SnapshotId, List>();
        for (IndexId indexId : repositoryData.getIndices().values()) {
            for (SnapshotId snapshotId : repositoryData.getSnapshots(indexId)) {
                if (!toResolve.contains(snapshotId)) continue;
                snapshotsToIndices.computeIfAbsent(snapshotId, k -> new ArrayList()).add(indexId.getName());
            }
        }
        for (Map.Entry entry : snapshotsToIndices.entrySet()) {
            SnapshotId snapshotId;
            List indices = (List)entry.getValue();
            CollectionUtil.timSort(indices);
            snapshotId = (SnapshotId)entry.getKey();
            snapshotInfos.add(new SnapshotInfo(snapshotId, indices, repositoryData.getSnapshotState(snapshotId)));
        }
        CollectionUtil.timSort(snapshotInfos);
        return Collections.unmodifiableList(snapshotInfos);
    }
}

