/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.bkd;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.bkd.HeapPointReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.bkd.PointReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.bkd.PointWriter;

public final class HeapPointWriter
implements PointWriter {
    public int[] docIDs;
    public long[] ordsLong;
    public int[] ords;
    private int nextWrite;
    private boolean closed;
    final int maxSize;
    public final int valuesPerBlock;
    final int packedBytesLength;
    final boolean singleValuePerDoc;
    public final List<byte[]> blocks = new ArrayList<byte[]>();

    public HeapPointWriter(int initSize, int maxSize, int packedBytesLength, boolean longOrds, boolean singleValuePerDoc) {
        this.docIDs = new int[initSize];
        this.maxSize = maxSize;
        this.packedBytesLength = packedBytesLength;
        this.singleValuePerDoc = singleValuePerDoc;
        if (singleValuePerDoc) {
            this.ordsLong = null;
            this.ords = null;
        } else if (longOrds) {
            this.ordsLong = new long[initSize];
        } else {
            this.ords = new int[initSize];
        }
        this.valuesPerBlock = Math.max(1, 4096 / packedBytesLength);
    }

    public void copyFrom(HeapPointWriter other) {
        if (this.docIDs.length < other.nextWrite) {
            throw new IllegalStateException("docIDs.length=" + this.docIDs.length + " other.nextWrite=" + other.nextWrite);
        }
        System.arraycopy(other.docIDs, 0, this.docIDs, 0, other.nextWrite);
        if (!this.singleValuePerDoc) {
            if (other.ords != null) {
                assert (this.ords != null);
                System.arraycopy(other.ords, 0, this.ords, 0, other.nextWrite);
            } else {
                assert (this.ordsLong != null);
                System.arraycopy(other.ordsLong, 0, this.ordsLong, 0, other.nextWrite);
            }
        }
        for (byte[] block : other.blocks) {
            this.blocks.add((byte[])block.clone());
        }
        this.nextWrite = other.nextWrite;
    }

    public void readPackedValue(int index, byte[] bytes) {
        assert (bytes.length == this.packedBytesLength);
        int block = index / this.valuesPerBlock;
        int blockIndex = index % this.valuesPerBlock;
        System.arraycopy(this.blocks.get(block), blockIndex * this.packedBytesLength, bytes, 0, this.packedBytesLength);
    }

    public void getPackedValueSlice(int index, BytesRef result) {
        int block = index / this.valuesPerBlock;
        int blockIndex = index % this.valuesPerBlock;
        result.bytes = this.blocks.get(block);
        result.offset = blockIndex * this.packedBytesLength;
        assert (result.length == this.packedBytesLength);
    }

    void writePackedValue(int index, byte[] bytes) {
        assert (bytes.length == this.packedBytesLength);
        int block = index / this.valuesPerBlock;
        int blockIndex = index % this.valuesPerBlock;
        while (this.blocks.size() <= block) {
            int valuesInBlock = Math.min(this.valuesPerBlock, this.maxSize - this.blocks.size() * this.valuesPerBlock);
            this.blocks.add(new byte[valuesInBlock * this.packedBytesLength]);
        }
        System.arraycopy(bytes, 0, this.blocks.get(block), blockIndex * this.packedBytesLength, this.packedBytesLength);
    }

    @Override
    public void append(byte[] packedValue, long ord, int docID) {
        assert (!this.closed);
        assert (packedValue.length == this.packedBytesLength);
        if (this.docIDs.length == this.nextWrite) {
            int nextSize = Math.min(this.maxSize, ArrayUtil.oversize(this.nextWrite + 1, 4));
            assert (nextSize > this.nextWrite) : "nextSize=" + nextSize + " vs nextWrite=" + this.nextWrite;
            this.docIDs = ArrayUtil.growExact(this.docIDs, nextSize);
            if (!this.singleValuePerDoc) {
                if (this.ordsLong != null) {
                    this.ordsLong = ArrayUtil.growExact(this.ordsLong, nextSize);
                } else {
                    this.ords = ArrayUtil.growExact(this.ords, nextSize);
                }
            }
        }
        this.writePackedValue(this.nextWrite, packedValue);
        if (!this.singleValuePerDoc) {
            if (this.ordsLong != null) {
                this.ordsLong[this.nextWrite] = ord;
            } else {
                assert (ord <= Integer.MAX_VALUE);
                this.ords[this.nextWrite] = (int)ord;
            }
        }
        this.docIDs[this.nextWrite] = docID;
        ++this.nextWrite;
    }

    @Override
    public PointReader getReader(long start, long length) {
        assert (start + length <= (long)this.docIDs.length) : "start=" + start + " length=" + length + " docIDs.length=" + this.docIDs.length;
        assert (start + length <= (long)this.nextWrite) : "start=" + start + " length=" + length + " nextWrite=" + this.nextWrite;
        return new HeapPointReader(this.blocks, this.valuesPerBlock, this.packedBytesLength, this.ords, this.ordsLong, this.docIDs, (int)start, Math.toIntExact(start + length), this.singleValuePerDoc);
    }

    @Override
    public PointReader getSharedReader(long start, long length, List<Closeable> toCloseHeroically) {
        return new HeapPointReader(this.blocks, this.valuesPerBlock, this.packedBytesLength, this.ords, this.ordsLong, this.docIDs, (int)start, this.nextWrite, this.singleValuePerDoc);
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void destroy() {
    }

    public String toString() {
        return "HeapPointWriter(count=" + this.nextWrite + " alloc=" + this.docIDs.length + ")";
    }
}

