/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.spatial4j;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.spatial4j.Geo3dCircleShape;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.spatial4j.Geo3dPointShape;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.spatial4j.Geo3dRectangleShape;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.spatial4j.Geo3dShape;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial.spatial4j.Geo3dSpatialContextFactory;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.GeoAreaShape;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.GeoBBox;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.GeoCircle;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.GeoPointShape;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.spatial3d.geom.SerializableObject;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.SpatialContextFactory;
import org.locationtech.spatial4j.io.BinaryCodec;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;

public class Geo3dBinaryCodec
extends BinaryCodec {
    private PlanetModel planetModel;

    public Geo3dBinaryCodec(SpatialContext ctx, SpatialContextFactory factory) {
        super(ctx, factory);
        this.planetModel = ((Geo3dSpatialContextFactory)factory).planetModel;
    }

    public Shape readShape(DataInput dataInput) throws IOException {
        SerializableObject serializableObject = SerializableObject.readObject(this.planetModel, (InputStream)((Object)dataInput));
        if (serializableObject instanceof GeoAreaShape) {
            GeoAreaShape shape = (GeoAreaShape)serializableObject;
            return new Geo3dShape<GeoAreaShape>(shape, this.ctx);
        }
        throw new IllegalArgumentException("trying to read a not supported shape: " + serializableObject.getClass());
    }

    public void writeShape(DataOutput dataOutput, Shape s) throws IOException {
        if (!(s instanceof Geo3dShape)) {
            throw new IllegalArgumentException("trying to write a not supported shape: " + s.getClass().getName());
        }
        Geo3dShape geoAreaShape = (Geo3dShape)s;
        SerializableObject.writeObject((OutputStream)((Object)dataOutput), geoAreaShape.shape);
    }

    public Point readPoint(DataInput dataInput) throws IOException {
        SerializableObject serializableObject = SerializableObject.readObject(this.planetModel, (InputStream)((Object)dataInput));
        if (serializableObject instanceof GeoPointShape) {
            GeoPointShape shape = (GeoPointShape)serializableObject;
            return new Geo3dPointShape(shape, this.ctx);
        }
        throw new IllegalArgumentException("trying to read a not supported point shape: " + serializableObject.getClass());
    }

    public void writePoint(DataOutput dataOutput, Point pt) throws IOException {
        this.writeShape(dataOutput, (Shape)pt);
    }

    public Rectangle readRect(DataInput dataInput) throws IOException {
        SerializableObject serializableObject = SerializableObject.readObject(this.planetModel, (InputStream)((Object)dataInput));
        if (serializableObject instanceof GeoBBox) {
            GeoBBox shape = (GeoBBox)serializableObject;
            return new Geo3dRectangleShape(shape, this.ctx);
        }
        throw new IllegalArgumentException("trying to read a not supported rectangle shape: " + serializableObject.getClass());
    }

    public void writeRect(DataOutput dataOutput, Rectangle r) throws IOException {
        this.writeShape(dataOutput, (Shape)r);
    }

    public Circle readCircle(DataInput dataInput) throws IOException {
        SerializableObject serializableObject = SerializableObject.readObject(this.planetModel, (InputStream)((Object)dataInput));
        if (serializableObject instanceof GeoCircle) {
            GeoCircle shape = (GeoCircle)serializableObject;
            return new Geo3dCircleShape(shape, this.ctx);
        }
        throw new IllegalArgumentException("trying to read a not supported circle shape: " + serializableObject.getClass());
    }

    public void writeCircle(DataOutput dataOutput, Circle c) throws IOException {
        this.writeShape(dataOutput, (Shape)c);
    }

    public ShapeCollection readCollection(DataInput dataInput) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeCollection(DataOutput dataOutput, ShapeCollection col) throws IOException {
        throw new UnsupportedOperationException();
    }
}

