/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.suggest.document;

import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.suggest.document.CompletionTokenStream;

public final class CompletionAnalyzer
extends AnalyzerWrapper {
    static final int HOLE_CHARACTER = 30;
    private final Analyzer analyzer;
    private final boolean preserveSep;
    private final boolean preservePositionIncrements;
    private final int maxGraphExpansions;

    public CompletionAnalyzer(Analyzer analyzer, boolean preserveSep, boolean preservePositionIncrements, int maxGraphExpansions) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.analyzer = analyzer;
        this.preserveSep = preserveSep;
        this.preservePositionIncrements = preservePositionIncrements;
        this.maxGraphExpansions = maxGraphExpansions;
    }

    public CompletionAnalyzer(Analyzer analyzer) {
        this(analyzer, true, true, 10000);
    }

    public CompletionAnalyzer(Analyzer analyzer, boolean preserveSep, boolean preservePositionIncrements) {
        this(analyzer, preserveSep, preservePositionIncrements, 10000);
    }

    public CompletionAnalyzer(Analyzer analyzer, int maxGraphExpansions) {
        this(analyzer, true, true, maxGraphExpansions);
    }

    public boolean preserveSep() {
        return this.preserveSep;
    }

    public boolean preservePositionIncrements() {
        return this.preservePositionIncrements;
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        return this.analyzer;
    }

    @Override
    protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
        CompletionTokenStream tokenStream = new CompletionTokenStream(components.getTokenStream(), this.preserveSep, this.preservePositionIncrements, this.maxGraphExpansions);
        return new Analyzer.TokenStreamComponents(components.getTokenizer(), tokenStream);
    }
}

