/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.spell;

import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.spell.StringDistance;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.IntsRef;

public final class LuceneLevenshteinDistance
implements StringDistance {
    @Override
    public float getDistance(String target, String other) {
        int j;
        int i;
        IntsRef targetPoints = LuceneLevenshteinDistance.toIntsRef(target);
        IntsRef otherPoints = LuceneLevenshteinDistance.toIntsRef(other);
        int n = targetPoints.length;
        int m = otherPoints.length;
        int[][] d = new int[n + 1][m + 1];
        if (n == 0 || m == 0) {
            if (n == m) {
                return 0.0f;
            }
            return Math.max(n, m);
        }
        for (i = 0; i <= n; ++i) {
            d[i][0] = i;
        }
        for (j = 0; j <= m; ++j) {
            d[0][j] = j;
        }
        for (j = 1; j <= m; ++j) {
            int t_j = otherPoints.ints[j - 1];
            for (i = 1; i <= n; ++i) {
                int cost = targetPoints.ints[i - 1] == t_j ? 0 : 1;
                d[i][j] = Math.min(Math.min(d[i - 1][j] + 1, d[i][j - 1] + 1), d[i - 1][j - 1] + cost);
                if (i <= 1 || j <= 1 || targetPoints.ints[i - 1] != otherPoints.ints[j - 2] || targetPoints.ints[i - 2] != otherPoints.ints[j - 1]) continue;
                d[i][j] = Math.min(d[i][j], d[i - 2][j - 2] + cost);
            }
        }
        return 1.0f - (float)d[n][m] / (float)Math.min(m, n);
    }

    private static IntsRef toIntsRef(String s) {
        IntsRef ref = new IntsRef(s.length());
        int utf16Len = s.length();
        int cp = 0;
        for (int i = 0; i < utf16Len; i += Character.charCount(cp)) {
            int n = Character.codePointAt(s, i);
            ref.ints[ref.length++] = n;
            cp = n;
        }
        return ref;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }
}

