/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.grouping;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Sort;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.TopDocs;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.TopDocsCollector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.TopFieldCollector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.TopScoreDocCollector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.grouping.GroupDocs;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.grouping.GroupReducer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.grouping.GroupSelector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.grouping.SearchGroup;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.grouping.SecondPassGroupingCollector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.grouping.TopGroups;

public class TopGroupsCollector<T>
extends SecondPassGroupingCollector<T> {
    private final Sort groupSort;
    private final Sort withinGroupSort;
    private final int maxDocsPerGroup;

    public TopGroupsCollector(GroupSelector<T> groupSelector, Collection<SearchGroup<T>> groups, Sort groupSort, Sort withinGroupSort, int maxDocsPerGroup, boolean getScores, boolean getMaxScores, boolean fillSortFields) {
        super(groupSelector, groups, new TopDocsReducer(withinGroupSort, maxDocsPerGroup, getScores, getMaxScores, fillSortFields));
        this.groupSort = Objects.requireNonNull(groupSort);
        this.withinGroupSort = Objects.requireNonNull(withinGroupSort);
        this.maxDocsPerGroup = maxDocsPerGroup;
    }

    public TopGroups<T> getTopGroups(int withinGroupOffset) {
        GroupDocs[] groupDocsResult = new GroupDocs[this.groups.size()];
        int groupIDX = 0;
        float maxScore = Float.MIN_VALUE;
        for (SearchGroup group : this.groups) {
            TopDocsCollector collector = (TopDocsCollector)this.groupReducer.getCollector(group.groupValue);
            TopDocs topDocs = collector.topDocs(withinGroupOffset, this.maxDocsPerGroup);
            groupDocsResult[groupIDX++] = new GroupDocs(Float.NaN, topDocs.getMaxScore(), topDocs.totalHits, topDocs.scoreDocs, group.groupValue, group.sortValues);
            maxScore = Math.max(maxScore, topDocs.getMaxScore());
        }
        return new TopGroups(this.groupSort.getSort(), this.withinGroupSort.getSort(), this.totalHitCount, this.totalGroupedHitCount, groupDocsResult, maxScore);
    }

    private static class TopDocsReducer<T>
    extends GroupReducer<T, TopDocsCollector<?>> {
        private final Supplier<TopDocsCollector<?>> supplier;
        private final boolean needsScores;

        TopDocsReducer(Sort withinGroupSort, int maxDocsPerGroup, boolean getScores, boolean getMaxScores, boolean fillSortFields) {
            this.needsScores = getScores || getMaxScores || withinGroupSort.needsScores();
            this.supplier = withinGroupSort == Sort.RELEVANCE ? () -> TopScoreDocCollector.create(maxDocsPerGroup) : () -> TopFieldCollector.create(withinGroupSort, maxDocsPerGroup, fillSortFields, getScores, getMaxScores, true);
        }

        @Override
        public boolean needsScores() {
            return this.needsScores;
        }

        @Override
        protected TopDocsCollector<?> newCollector() {
            return this.supplier.get();
        }
    }
}

