/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.queries.function.ValueSource;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.CachingCollector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Collector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.MultiCollector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Sort;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.grouping.AllGroupHeadsCollector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.grouping.AllGroupsCollector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.grouping.BlockGroupingCollector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.grouping.FirstPassGroupingCollector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.grouping.GroupDocs;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.grouping.GroupSelector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.grouping.TermGroupSelector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.grouping.TopGroups;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.grouping.TopGroupsCollector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.grouping.ValueSourceGroupSelector;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.Bits;

public class GroupingSearch {
    private final GroupSelector grouper;
    private final Query groupEndDocs;
    private Sort groupSort = Sort.RELEVANCE;
    private Sort sortWithinGroup = Sort.RELEVANCE;
    private int groupDocsOffset;
    private int groupDocsLimit = 1;
    private boolean fillSortFields;
    private boolean includeScores = true;
    private boolean includeMaxScore = true;
    private Double maxCacheRAMMB;
    private Integer maxDocsToCache;
    private boolean cacheScores;
    private boolean allGroups;
    private boolean allGroupHeads;
    private Collection<?> matchingGroups;
    private Bits matchingGroupHeads;

    public GroupingSearch(String groupField) {
        this(new TermGroupSelector(groupField), null);
    }

    public GroupingSearch(ValueSource groupFunction, Map<?, ?> valueSourceContext) {
        this(new ValueSourceGroupSelector(groupFunction, valueSourceContext), null);
    }

    public GroupingSearch(Query groupEndDocs) {
        this(null, groupEndDocs);
    }

    private GroupingSearch(GroupSelector grouper, Query groupEndDocs) {
        this.grouper = grouper;
        this.groupEndDocs = groupEndDocs;
    }

    public <T> TopGroups<T> search(IndexSearcher searcher, Query query, int groupOffset, int groupLimit) throws IOException {
        if (this.grouper != null) {
            return this.groupByFieldOrFunction(searcher, query, groupOffset, groupLimit);
        }
        if (this.groupEndDocs != null) {
            return this.groupByDocBlock(searcher, query, groupOffset, groupLimit);
        }
        throw new IllegalStateException("Either groupField, groupFunction or groupEndDocs must be set.");
    }

    protected TopGroups groupByFieldOrFunction(IndexSearcher searcher, Query query, int groupOffset, int groupLimit) throws IOException {
        int topN = groupOffset + groupLimit;
        FirstPassGroupingCollector firstPassCollector = new FirstPassGroupingCollector(this.grouper, this.groupSort, topN);
        AllGroupsCollector allGroupsCollector = this.allGroups ? new AllGroupsCollector(this.grouper) : null;
        AllGroupHeadsCollector allGroupHeadsCollector = this.allGroupHeads ? AllGroupHeadsCollector.newCollector(this.grouper, this.sortWithinGroup) : null;
        Collector firstRound = MultiCollector.wrap(firstPassCollector, allGroupsCollector, allGroupHeadsCollector);
        CachingCollector cachedCollector = null;
        if (this.maxCacheRAMMB != null || this.maxDocsToCache != null) {
            cachedCollector = this.maxCacheRAMMB != null ? CachingCollector.create(firstRound, this.cacheScores, this.maxCacheRAMMB) : CachingCollector.create(firstRound, this.cacheScores, this.maxDocsToCache);
            searcher.search(query, cachedCollector);
        } else {
            searcher.search(query, firstRound);
        }
        this.matchingGroups = this.allGroups ? allGroupsCollector.getGroups() : Collections.emptyList();
        this.matchingGroupHeads = this.allGroupHeads ? allGroupHeadsCollector.retrieveGroupHeads(searcher.getIndexReader().maxDoc()) : new Bits.MatchNoBits(searcher.getIndexReader().maxDoc());
        Collection topSearchGroups = firstPassCollector.getTopGroups(groupOffset, this.fillSortFields);
        if (topSearchGroups == null) {
            return new TopGroups(new SortField[0], new SortField[0], 0, 0, new GroupDocs[0], Float.NaN);
        }
        int topNInsideGroup = this.groupDocsOffset + this.groupDocsLimit;
        TopGroupsCollector secondPassCollector = new TopGroupsCollector(this.grouper, topSearchGroups, this.groupSort, this.sortWithinGroup, topNInsideGroup, this.includeScores, this.includeMaxScore, this.fillSortFields);
        if (cachedCollector != null && cachedCollector.isCached()) {
            cachedCollector.replay(secondPassCollector);
        } else {
            searcher.search(query, secondPassCollector);
        }
        if (this.allGroups) {
            return new TopGroups(secondPassCollector.getTopGroups(this.groupDocsOffset), this.matchingGroups.size());
        }
        return secondPassCollector.getTopGroups(this.groupDocsOffset);
    }

    protected TopGroups<?> groupByDocBlock(IndexSearcher searcher, Query query, int groupOffset, int groupLimit) throws IOException {
        int topN = groupOffset + groupLimit;
        Query endDocsQuery = searcher.rewrite(this.groupEndDocs);
        Weight groupEndDocs = searcher.createWeight(endDocsQuery, false, 1.0f);
        BlockGroupingCollector c = new BlockGroupingCollector(this.groupSort, topN, this.includeScores, groupEndDocs);
        searcher.search(query, c);
        int topNInsideGroup = this.groupDocsOffset + this.groupDocsLimit;
        return c.getTopGroups(this.sortWithinGroup, groupOffset, this.groupDocsOffset, topNInsideGroup, this.fillSortFields);
    }

    public GroupingSearch setCachingInMB(double maxCacheRAMMB, boolean cacheScores) {
        this.maxCacheRAMMB = maxCacheRAMMB;
        this.maxDocsToCache = null;
        this.cacheScores = cacheScores;
        return this;
    }

    public GroupingSearch setCaching(int maxDocsToCache, boolean cacheScores) {
        this.maxDocsToCache = maxDocsToCache;
        this.maxCacheRAMMB = null;
        this.cacheScores = cacheScores;
        return this;
    }

    public GroupingSearch disableCaching() {
        this.maxCacheRAMMB = null;
        this.maxDocsToCache = null;
        return this;
    }

    public GroupingSearch setGroupSort(Sort groupSort) {
        this.groupSort = groupSort;
        return this;
    }

    public GroupingSearch setSortWithinGroup(Sort sortWithinGroup) {
        this.sortWithinGroup = sortWithinGroup;
        return this;
    }

    public GroupingSearch setGroupDocsOffset(int groupDocsOffset) {
        this.groupDocsOffset = groupDocsOffset;
        return this;
    }

    public GroupingSearch setGroupDocsLimit(int groupDocsLimit) {
        this.groupDocsLimit = groupDocsLimit;
        return this;
    }

    public GroupingSearch setFillSortFields(boolean fillSortFields) {
        this.fillSortFields = fillSortFields;
        return this;
    }

    public GroupingSearch setIncludeScores(boolean includeScores) {
        this.includeScores = includeScores;
        return this;
    }

    public GroupingSearch setIncludeMaxScore(boolean includeMaxScore) {
        this.includeMaxScore = includeMaxScore;
        return this;
    }

    public GroupingSearch setAllGroups(boolean allGroups) {
        this.allGroups = allGroups;
        return this;
    }

    public <T> Collection<T> getAllMatchingGroups() {
        return this.matchingGroups;
    }

    public GroupingSearch setAllGroupHeads(boolean allGroupHeads) {
        this.allGroupHeads = allGroupHeads;
        return this;
    }

    public Bits getAllGroupHeads() {
        return this.matchingGroupHeads;
    }
}

