/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search;

import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.FieldComparator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.FieldDoc;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.ScoreDoc;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Sort;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.TopFieldDocs;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.PriorityQueue;

public class TopDocs {
    public long totalHits;
    public ScoreDoc[] scoreDocs;
    private float maxScore;

    public float getMaxScore() {
        return this.maxScore;
    }

    public void setMaxScore(float maxScore) {
        this.maxScore = maxScore;
    }

    TopDocs(long totalHits, ScoreDoc[] scoreDocs) {
        this(totalHits, scoreDocs, Float.NaN);
    }

    public TopDocs(long totalHits, ScoreDoc[] scoreDocs, float maxScore) {
        this.totalHits = totalHits;
        this.scoreDocs = scoreDocs;
        this.maxScore = maxScore;
    }

    static boolean tieBreakLessThan(ShardRef first, ScoreDoc firstDoc, ShardRef second, ScoreDoc secondDoc) {
        int secondShardIndex;
        int firstShardIndex = first.getShardIndex(firstDoc);
        if (firstShardIndex < (secondShardIndex = second.getShardIndex(secondDoc))) {
            return true;
        }
        if (firstShardIndex > secondShardIndex) {
            return false;
        }
        assert (first.hitIndex != second.hitIndex);
        return first.hitIndex < second.hitIndex;
    }

    public static TopDocs merge(int topN, TopDocs[] shardHits) {
        return TopDocs.merge(0, topN, shardHits, true);
    }

    public static TopDocs merge(int start, int topN, TopDocs[] shardHits, boolean setShardIndex) {
        return TopDocs.mergeAux(null, start, topN, shardHits, setShardIndex);
    }

    public static TopFieldDocs merge(Sort sort, int topN, TopFieldDocs[] shardHits) {
        return TopDocs.merge(sort, 0, topN, shardHits, true);
    }

    public static TopFieldDocs merge(Sort sort, int start, int topN, TopFieldDocs[] shardHits, boolean setShardIndex) {
        if (sort == null) {
            throw new IllegalArgumentException("sort must be non-null when merging field-docs");
        }
        return (TopFieldDocs)TopDocs.mergeAux(sort, start, topN, shardHits, setShardIndex);
    }

    private static TopDocs mergeAux(Sort sort, int start, int size, TopDocs[] shardHits, boolean setShardIndex) {
        ScoreDoc[] hits;
        PriorityQueue queue = sort == null ? new ScoreMergeSortQueue(shardHits) : new MergeSortQueue(sort, shardHits);
        long totalHitCount = 0L;
        int availHitCount = 0;
        float maxScore = Float.MIN_VALUE;
        for (int shardIDX = 0; shardIDX < shardHits.length; ++shardIDX) {
            TopDocs shard = shardHits[shardIDX];
            totalHitCount += shard.totalHits;
            if (shard.scoreDocs == null || shard.scoreDocs.length <= 0) continue;
            availHitCount += shard.scoreDocs.length;
            queue.add(new ShardRef(shardIDX, !setShardIndex));
            maxScore = Math.max(maxScore, shard.getMaxScore());
        }
        if (availHitCount == 0) {
            maxScore = Float.NaN;
        }
        if (availHitCount <= start) {
            hits = new ScoreDoc[]{};
        } else {
            hits = new ScoreDoc[Math.min(size, availHitCount - start)];
            int requestedResultWindow = start + size;
            int numIterOnHits = Math.min(availHitCount, requestedResultWindow);
            for (int hitUpto = 0; hitUpto < numIterOnHits; ++hitUpto) {
                assert (queue.size() > 0);
                ShardRef ref = (ShardRef)queue.top();
                ScoreDoc hit = shardHits[ref.shardIndex].scoreDocs[ref.hitIndex++];
                if (setShardIndex) {
                    hit.shardIndex = ref.shardIndex;
                } else if (hit.shardIndex == -1) {
                    throw new IllegalArgumentException("setShardIndex is false but TopDocs[" + ref.shardIndex + "].scoreDocs[" + (ref.hitIndex - 1) + "] is not set");
                }
                if (hitUpto >= start) {
                    hits[hitUpto - start] = hit;
                }
                if (ref.hitIndex < shardHits[ref.shardIndex].scoreDocs.length) {
                    queue.updateTop();
                    continue;
                }
                queue.pop();
            }
        }
        if (sort == null) {
            return new TopDocs(totalHitCount, hits, maxScore);
        }
        return new TopFieldDocs(totalHitCount, hits, sort.getSort(), maxScore);
    }

    private static class MergeSortQueue
    extends PriorityQueue<ShardRef> {
        final ScoreDoc[][] shardHits;
        final FieldComparator<?>[] comparators;
        final int[] reverseMul;

        public MergeSortQueue(Sort sort, TopDocs[] shardHits) {
            super(shardHits.length);
            this.shardHits = new ScoreDoc[shardHits.length][];
            for (int shardIDX = 0; shardIDX < shardHits.length; ++shardIDX) {
                ScoreDoc[] shard = shardHits[shardIDX].scoreDocs;
                if (shard == null) continue;
                this.shardHits[shardIDX] = shard;
                for (int hitIDX = 0; hitIDX < shard.length; ++hitIDX) {
                    ScoreDoc sd = shard[hitIDX];
                    if (!(sd instanceof FieldDoc)) {
                        throw new IllegalArgumentException("shard " + shardIDX + " was not sorted by the provided Sort (expected FieldDoc but got ScoreDoc)");
                    }
                    FieldDoc fd = (FieldDoc)sd;
                    if (fd.fields != null) continue;
                    throw new IllegalArgumentException("shard " + shardIDX + " did not set sort field values (FieldDoc.fields is null); you must pass fillFields=true to IndexSearcher.search on each shard");
                }
            }
            SortField[] sortFields = sort.getSort();
            this.comparators = new FieldComparator[sortFields.length];
            this.reverseMul = new int[sortFields.length];
            for (int compIDX = 0; compIDX < sortFields.length; ++compIDX) {
                SortField sortField = sortFields[compIDX];
                this.comparators[compIDX] = sortField.getComparator(1, compIDX);
                this.reverseMul[compIDX] = sortField.getReverse() ? -1 : 1;
            }
        }

        @Override
        public boolean lessThan(ShardRef first, ShardRef second) {
            assert (first != second);
            FieldDoc firstFD = (FieldDoc)this.shardHits[first.shardIndex][first.hitIndex];
            FieldDoc secondFD = (FieldDoc)this.shardHits[second.shardIndex][second.hitIndex];
            for (int compIDX = 0; compIDX < this.comparators.length; ++compIDX) {
                FieldComparator<?> comp = this.comparators[compIDX];
                int cmp = this.reverseMul[compIDX] * comp.compareValues(firstFD.fields[compIDX], secondFD.fields[compIDX]);
                if (cmp == 0) continue;
                return cmp < 0;
            }
            return TopDocs.tieBreakLessThan(first, firstFD, second, secondFD);
        }
    }

    private static class ScoreMergeSortQueue
    extends PriorityQueue<ShardRef> {
        final ScoreDoc[][] shardHits;

        public ScoreMergeSortQueue(TopDocs[] shardHits) {
            super(shardHits.length);
            this.shardHits = new ScoreDoc[shardHits.length][];
            for (int shardIDX = 0; shardIDX < shardHits.length; ++shardIDX) {
                this.shardHits[shardIDX] = shardHits[shardIDX].scoreDocs;
            }
        }

        @Override
        public boolean lessThan(ShardRef first, ShardRef second) {
            assert (first != second);
            ScoreDoc firstScoreDoc = this.shardHits[first.shardIndex][first.hitIndex];
            ScoreDoc secondScoreDoc = this.shardHits[second.shardIndex][second.hitIndex];
            if (firstScoreDoc.score < secondScoreDoc.score) {
                return false;
            }
            if (firstScoreDoc.score > secondScoreDoc.score) {
                return true;
            }
            return TopDocs.tieBreakLessThan(first, firstScoreDoc, second, secondScoreDoc);
        }
    }

    private static final class ShardRef {
        final int shardIndex;
        final boolean useScoreDocIndex;
        int hitIndex;

        ShardRef(int shardIndex, boolean useScoreDocIndex) {
            this.shardIndex = shardIndex;
            this.useScoreDocIndex = useScoreDocIndex;
        }

        public String toString() {
            return "ShardRef(shardIndex=" + this.shardIndex + " hitIndex=" + this.hitIndex + ")";
        }

        int getShardIndex(ScoreDoc scoreDoc) {
            if (this.useScoreDocIndex) {
                if (scoreDoc.shardIndex == -1) {
                    throw new IllegalArgumentException("setShardIndex is false but TopDocs[" + this.shardIndex + "].scoreDocs[" + this.hitIndex + "] is not set");
                }
                return scoreDoc.shardIndex;
            }
            return this.shardIndex;
        }
    }
}

