/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.TwoPhaseIterator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.similarities.Similarity;

abstract class PhraseMatcher {
    protected final DocIdSetIterator approximation;
    private final float matchCost;

    PhraseMatcher(DocIdSetIterator approximation, float matchCost) {
        assert (TwoPhaseIterator.unwrap(approximation) == null);
        this.approximation = approximation;
        this.matchCost = matchCost;
    }

    abstract float maxFreq() throws IOException;

    public abstract void reset() throws IOException;

    public abstract boolean nextMatch() throws IOException;

    abstract float sloppyWeight(Similarity.SimScorer var1);

    abstract int startPosition();

    abstract int endPosition();

    abstract int startOffset() throws IOException;

    abstract int endOffset() throws IOException;

    public float getMatchCost() {
        return this.matchCost;
    }
}

