/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.queries;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.queries.CustomScoreProvider;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.queries.function.FunctionQuery;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.FilterScorer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.Weight;

@Deprecated
public class CustomScoreQuery
extends Query
implements Cloneable {
    private Query subQuery;
    private Query[] scoringQueries;

    public CustomScoreQuery(Query subQuery) {
        this(subQuery, new FunctionQuery[0]);
    }

    public CustomScoreQuery(Query subQuery, FunctionQuery scoringQuery) {
        FunctionQuery[] functionQueryArray;
        if (scoringQuery != null) {
            FunctionQuery[] functionQueryArray2 = new FunctionQuery[1];
            functionQueryArray = functionQueryArray2;
            functionQueryArray2[0] = scoringQuery;
        } else {
            functionQueryArray = new FunctionQuery[]{};
        }
        this(subQuery, functionQueryArray);
    }

    public CustomScoreQuery(Query subQuery, FunctionQuery ... scoringQueries) {
        this.subQuery = subQuery;
        Query[] queryArray = this.scoringQueries = scoringQueries != null ? scoringQueries : new Query[]{};
        if (subQuery == null) {
            throw new IllegalArgumentException("<subquery> must not be null!");
        }
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        CustomScoreQuery clone = null;
        Query sq = this.subQuery.rewrite(reader);
        if (sq != this.subQuery) {
            clone = this.clone();
            clone.subQuery = sq;
        }
        for (int i = 0; i < this.scoringQueries.length; ++i) {
            Query v = this.scoringQueries[i].rewrite(reader);
            if (v == this.scoringQueries[i]) continue;
            if (clone == null) {
                clone = this.clone();
            }
            clone.scoringQueries[i] = v;
        }
        return clone == null ? this : clone;
    }

    public CustomScoreQuery clone() {
        CustomScoreQuery clone;
        try {
            clone = (CustomScoreQuery)super.clone();
        }
        catch (CloneNotSupportedException bogus) {
            throw new Error(bogus);
        }
        clone.subQuery = this.subQuery;
        clone.scoringQueries = new Query[this.scoringQueries.length];
        for (int i = 0; i < this.scoringQueries.length; ++i) {
            clone.scoringQueries[i] = this.scoringQueries[i];
        }
        return clone;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder(this.name()).append("(");
        sb.append(this.subQuery.toString(field));
        for (Query scoringQuery : this.scoringQueries) {
            sb.append(", ").append(scoringQuery.toString(field));
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((CustomScoreQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(CustomScoreQuery other) {
        return this.subQuery.equals(other.subQuery) && this.scoringQueries.length == other.scoringQueries.length && Arrays.equals(this.scoringQueries, other.scoringQueries);
    }

    @Override
    public int hashCode() {
        return this.classHash() + this.subQuery.hashCode() + Arrays.hashCode(this.scoringQueries);
    }

    protected CustomScoreProvider getCustomScoreProvider(LeafReaderContext context) throws IOException {
        return new CustomScoreProvider(context);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        return new CustomWeight(searcher, needsScores, boost);
    }

    public Query getSubQuery() {
        return this.subQuery;
    }

    public Query[] getScoringQueries() {
        return this.scoringQueries;
    }

    public String name() {
        return "custom";
    }

    private static class CustomScorer
    extends FilterScorer {
        private final float qWeight;
        private final Scorer subQueryScorer;
        private final Scorer[] valSrcScorers;
        private final CustomScoreProvider provider;
        private final float[] vScores;
        private int valSrcDocID = -1;

        private CustomScorer(CustomScoreProvider provider, CustomWeight w, float qWeight, Scorer subQueryScorer, Scorer[] valSrcScorers) {
            super(subQueryScorer, w);
            this.qWeight = qWeight;
            this.subQueryScorer = subQueryScorer;
            this.valSrcScorers = valSrcScorers;
            this.vScores = new float[valSrcScorers.length];
            this.provider = provider;
        }

        @Override
        public float score() throws IOException {
            int doc = this.docID();
            if (doc > this.valSrcDocID) {
                for (Scorer valSrcScorer : this.valSrcScorers) {
                    valSrcScorer.iterator().advance(doc);
                }
                this.valSrcDocID = doc;
            }
            for (int i = 0; i < this.valSrcScorers.length; ++i) {
                this.vScores[i] = this.valSrcScorers[i].score();
            }
            return this.qWeight * this.provider.customScore(this.subQueryScorer.docID(), this.subQueryScorer.score(), this.vScores);
        }

        @Override
        public Collection<Scorer.ChildScorer> getChildren() {
            return Collections.singleton(new Scorer.ChildScorer(this.subQueryScorer, "CUSTOM"));
        }
    }

    private class CustomWeight
    extends Weight {
        final Weight subQueryWeight;
        final Weight[] valSrcWeights;
        final float queryWeight;

        public CustomWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
            super(CustomScoreQuery.this);
            this.subQueryWeight = CustomScoreQuery.this.subQuery.createWeight(searcher, needsScores, 1.0f);
            this.valSrcWeights = new Weight[CustomScoreQuery.this.scoringQueries.length];
            for (int i = 0; i < CustomScoreQuery.this.scoringQueries.length; ++i) {
                this.valSrcWeights[i] = CustomScoreQuery.this.scoringQueries[i].createWeight(searcher, needsScores, 1.0f);
            }
            this.queryWeight = boost;
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            this.subQueryWeight.extractTerms(terms);
            for (Weight scoringWeight : this.valSrcWeights) {
                scoringWeight.extractTerms(terms);
            }
        }

        @Override
        public Scorer scorer(LeafReaderContext context) throws IOException {
            Scorer subQueryScorer = this.subQueryWeight.scorer(context);
            if (subQueryScorer == null) {
                return null;
            }
            Scorer[] valSrcScorers = new Scorer[this.valSrcWeights.length];
            for (int i = 0; i < valSrcScorers.length; ++i) {
                valSrcScorers[i] = this.valSrcWeights[i].scorer(context);
            }
            return new CustomScorer(CustomScoreQuery.this.getCustomScoreProvider(context), this, this.queryWeight, subQueryScorer, valSrcScorers);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            if (!this.subQueryWeight.isCacheable(ctx)) {
                return false;
            }
            for (Weight w : this.valSrcWeights) {
                if (w.isCacheable(ctx)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            Explanation explain = this.doExplain(context, doc);
            return explain == null ? Explanation.noMatch("no matching docs", new Explanation[0]) : explain;
        }

        private Explanation doExplain(LeafReaderContext info, int doc) throws IOException {
            Explanation subQueryExpl = this.subQueryWeight.explain(info, doc);
            if (!subQueryExpl.isMatch()) {
                return subQueryExpl;
            }
            Explanation[] valSrcExpls = new Explanation[this.valSrcWeights.length];
            for (int i = 0; i < this.valSrcWeights.length; ++i) {
                valSrcExpls[i] = this.valSrcWeights[i].explain(info, doc);
            }
            Explanation customExp = CustomScoreQuery.this.getCustomScoreProvider(info).customExplain(doc, subQueryExpl, valSrcExpls);
            float sc = this.queryWeight * customExp.getValue();
            return Explanation.match(sc, CustomScoreQuery.this.toString() + ", product of:", customExp, Explanation.match(this.queryWeight, "queryWeight", new Explanation[0]));
        }
    }
}

