/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.document;

import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.document.LatLonPointDistanceComparator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.geo.GeoUtils;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.FieldComparator;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.search.SortField;

final class LatLonPointSortField
extends SortField {
    final double latitude;
    final double longitude;

    LatLonPointSortField(String field, double latitude, double longitude) {
        super(field, SortField.Type.CUSTOM);
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        GeoUtils.checkLatitude(latitude);
        GeoUtils.checkLongitude(longitude);
        this.latitude = latitude;
        this.longitude = longitude;
        this.setMissingValue(Double.POSITIVE_INFINITY);
    }

    @Override
    public FieldComparator<?> getComparator(int numHits, int sortPos) {
        return new LatLonPointDistanceComparator(this.getField(), this.latitude, this.longitude, numHits);
    }

    @Override
    public Double getMissingValue() {
        return (Double)super.getMissingValue();
    }

    @Override
    public void setMissingValue(Object missingValue) {
        if (!Double.valueOf(Double.POSITIVE_INFINITY).equals(missingValue)) {
            throw new IllegalArgumentException("Missing value can only be Double.POSITIVE_INFINITY (missing values last), but got " + missingValue);
        }
        this.missingValue = missingValue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LatLonPointSortField other = (LatLonPointSortField)obj;
        if (Double.doubleToLongBits(this.latitude) != Double.doubleToLongBits(other.latitude)) {
            return false;
        }
        return Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(other.longitude);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<distance:");
        builder.append('\"');
        builder.append(this.getField());
        builder.append('\"');
        builder.append(" latitude=");
        builder.append(this.latitude);
        builder.append(" longitude=");
        builder.append(this.longitude);
        if (Double.POSITIVE_INFINITY != this.getMissingValue()) {
            builder.append(" missingValue=" + this.getMissingValue());
        }
        builder.append('>');
        return builder.toString();
    }
}

