/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.ngram;

import java.io.IOException;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.TokenFilter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.AttributeSource;

public final class NGramTokenFilter
extends TokenFilter {
    @Deprecated
    public static final int DEFAULT_MIN_NGRAM_SIZE = 1;
    @Deprecated
    public static final int DEFAULT_MAX_NGRAM_SIZE = 2;
    public static final boolean DEFAULT_PRESERVE_ORIGINAL = false;
    private final int minGram;
    private final int maxGram;
    private final boolean preserveOriginal;
    private char[] curTermBuffer;
    private int curTermLength;
    private int curTermCodePointCount;
    private int curGramSize;
    private int curPos;
    private int curPosIncr;
    private AttributeSource.State state;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);

    public NGramTokenFilter(TokenStream input, int minGram, int maxGram, boolean preserveOriginal) {
        super(input);
        if (minGram < 1) {
            throw new IllegalArgumentException("minGram must be greater than zero");
        }
        if (minGram > maxGram) {
            throw new IllegalArgumentException("minGram must not be greater than maxGram");
        }
        this.minGram = minGram;
        this.maxGram = maxGram;
        this.preserveOriginal = preserveOriginal;
    }

    public NGramTokenFilter(TokenStream input, int gramSize) {
        this(input, gramSize, gramSize, false);
    }

    @Deprecated
    public NGramTokenFilter(TokenStream input, int minGram, int maxGram) {
        this(input, minGram, maxGram, false);
    }

    @Deprecated
    public NGramTokenFilter(TokenStream input) {
        this(input, 1, 2, false);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        while (true) {
            if (this.curTermBuffer == null) {
                if (!this.input.incrementToken()) {
                    return false;
                }
                this.state = this.captureState();
                this.curTermLength = this.termAtt.length();
                this.curTermCodePointCount = Character.codePointCount(this.termAtt, 0, this.termAtt.length());
                this.curPosIncr += this.posIncrAtt.getPositionIncrement();
                this.curPos = 0;
                if (this.preserveOriginal && this.curTermCodePointCount < this.minGram) {
                    this.posIncrAtt.setPositionIncrement(this.curPosIncr);
                    this.curPosIncr = 0;
                    return true;
                }
                this.curTermBuffer = (char[])this.termAtt.buffer().clone();
                this.curGramSize = this.minGram;
            }
            if (this.curGramSize > this.maxGram || this.curPos + this.curGramSize > this.curTermCodePointCount) {
                ++this.curPos;
                this.curGramSize = this.minGram;
            }
            if (this.curPos + this.curGramSize <= this.curTermCodePointCount) {
                this.restoreState(this.state);
                int start = Character.offsetByCodePoints(this.curTermBuffer, 0, this.curTermLength, 0, this.curPos);
                int end = Character.offsetByCodePoints(this.curTermBuffer, 0, this.curTermLength, start, this.curGramSize);
                this.termAtt.copyBuffer(this.curTermBuffer, start, end - start);
                this.posIncrAtt.setPositionIncrement(this.curPosIncr);
                this.curPosIncr = 0;
                ++this.curGramSize;
                return true;
            }
            if (this.preserveOriginal && this.curTermCodePointCount > this.maxGram) {
                this.restoreState(this.state);
                this.posIncrAtt.setPositionIncrement(0);
                this.termAtt.copyBuffer(this.curTermBuffer, 0, this.curTermLength);
                this.curTermBuffer = null;
                return true;
            }
            this.curTermBuffer = null;
        }
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.curTermBuffer = null;
        this.curPosIncr = 0;
    }

    @Override
    public void end() throws IOException {
        super.end();
        this.posIncrAtt.setPositionIncrement(this.curPosIncr);
    }
}

