/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.miscellaneous;

import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.miscellaneous.ConcatenateGraphFilter;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.util.TokenFilterFactory;

public class ConcatenateGraphFilterFactory
extends TokenFilterFactory {
    private boolean preserveSep;
    private boolean preservePositionIncrements;
    private int maxGraphExpansions;

    public ConcatenateGraphFilterFactory(Map<String, String> args) {
        super(args);
        this.preserveSep = this.getBoolean(args, "preserveSep", true);
        this.preservePositionIncrements = this.getBoolean(args, "preservePositionIncrements", true);
        this.maxGraphExpansions = this.getInt(args, "maxGraphExpansions", 10000);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new ConcatenateGraphFilter(input, this.preserveSep, this.preservePositionIncrements, this.maxGraphExpansions);
    }
}

