/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.table;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Period;
import java.util.List;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.elasticsearch.table.LogicalTypeWithIndex;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.function.SerializableFunction;

@Internal
class KeyExtractor
implements SerializableFunction<RowData, String> {
    private final FieldFormatter[] fieldFormatters;
    private final String keyDelimiter;

    private KeyExtractor(FieldFormatter[] fieldFormatters, String keyDelimiter) {
        this.fieldFormatters = fieldFormatters;
        this.keyDelimiter = keyDelimiter;
    }

    public String apply(RowData rowData) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.fieldFormatters.length; ++i) {
            if (i > 0) {
                builder.append(this.keyDelimiter);
            }
            String value = this.fieldFormatters[i].format(rowData);
            builder.append(value);
        }
        return builder.toString();
    }

    public static SerializableFunction<RowData, String> createKeyExtractor(List<LogicalTypeWithIndex> primaryKeyTypesWithIndex, String keyDelimiter) {
        if (!primaryKeyTypesWithIndex.isEmpty()) {
            FieldFormatter[] formatters = (FieldFormatter[])primaryKeyTypesWithIndex.stream().map(logicalTypeWithIndex -> KeyExtractor.toFormatter(logicalTypeWithIndex.index, logicalTypeWithIndex.logicalType)).toArray(FieldFormatter[]::new);
            return new KeyExtractor(formatters, keyDelimiter);
        }
        return (SerializableFunction & Serializable)row -> null;
    }

    private static FieldFormatter toFormatter(int index, LogicalType type) {
        switch (type.getTypeRoot()) {
            case DATE: {
                return row -> LocalDate.ofEpochDay(row.getInt(index)).toString();
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return row -> LocalTime.ofNanoOfDay((long)row.getInt(index) * 1000000L).toString();
            }
            case INTERVAL_YEAR_MONTH: {
                return row -> Period.ofDays(row.getInt(index)).toString();
            }
            case INTERVAL_DAY_TIME: {
                return row -> Duration.ofMillis(row.getLong(index)).toString();
            }
            case DISTINCT_TYPE: {
                return KeyExtractor.toFormatter(index, ((DistinctType)type).getSourceType());
            }
        }
        RowData.FieldGetter fieldGetter = RowData.createFieldGetter((LogicalType)type, (int)index);
        return row -> fieldGetter.getFieldOrNull(row).toString();
    }

    private static interface FieldFormatter
    extends Serializable {
        public String format(RowData var1);
    }
}

