/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.table;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.connector.elasticsearch.sink.Elasticsearch6SinkBuilder;
import org.apache.flink.connector.elasticsearch.table.Elasticsearch6Configuration;
import org.apache.flink.connector.elasticsearch.table.Elasticsearch6ConnectorOptions;
import org.apache.flink.connector.elasticsearch.table.ElasticsearchConfiguration;
import org.apache.flink.connector.elasticsearch.table.ElasticsearchDynamicSinkFactoryBase;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.util.StringUtils;

@Internal
public class Elasticsearch6DynamicSinkFactory
extends ElasticsearchDynamicSinkFactoryBase {
    private static final String FACTORY_IDENTIFIER = "elasticsearch-6";

    public Elasticsearch6DynamicSinkFactory() {
        super(FACTORY_IDENTIFIER, Elasticsearch6SinkBuilder::new);
    }

    @Override
    ElasticsearchConfiguration getConfiguration(FactoryUtil.TableFactoryHelper helper) {
        return new Elasticsearch6Configuration(helper.getOptions());
    }

    @Override
    @Nullable
    String getDocumentType(ElasticsearchConfiguration configuration) {
        return ((Elasticsearch6Configuration)configuration).getDocumentType();
    }

    @Override
    void validateConfiguration(ElasticsearchConfiguration config) {
        super.validateConfiguration(config);
        Elasticsearch6Configuration configuration = (Elasticsearch6Configuration)config;
        Elasticsearch6DynamicSinkFactory.validate(!StringUtils.isNullOrWhitespaceOnly((String)configuration.getDocumentType()), () -> String.format("'%s' must not be empty", Elasticsearch6ConnectorOptions.DOCUMENT_TYPE_OPTION.key()));
    }

    @Override
    public Set<ConfigOption<?>> requiredOptions() {
        Set<ConfigOption<?>> requiredOptions = super.requiredOptions();
        requiredOptions.add(Elasticsearch6ConnectorOptions.DOCUMENT_TYPE_OPTION);
        return requiredOptions;
    }

    @Override
    public Set<ConfigOption<?>> forwardOptions() {
        return Stream.concat(super.forwardOptions().stream(), Stream.of(Elasticsearch6ConnectorOptions.DOCUMENT_TYPE_OPTION)).collect(Collectors.toSet());
    }
}

