/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.elasticsearch.sink;

import java.util.Arrays;
import java.util.List;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.connector.base.DeliveryGuarantee;
import org.apache.flink.connector.elasticsearch.sink.BulkProcessorBuilderFactory;
import org.apache.flink.connector.elasticsearch.sink.BulkProcessorConfig;
import org.apache.flink.connector.elasticsearch.sink.ElasticsearchEmitter;
import org.apache.flink.connector.elasticsearch.sink.ElasticsearchSink;
import org.apache.flink.connector.elasticsearch.sink.FlushBackoffType;
import org.apache.flink.connector.elasticsearch.sink.NetworkClientConfig;
import org.apache.flink.elasticsearch6.shaded.org.apache.http.HttpHost;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public abstract class ElasticsearchSinkBuilderBase<IN, B extends ElasticsearchSinkBuilderBase<IN, B>> {
    private int bulkFlushMaxActions = 1000;
    private int bulkFlushMaxMb = -1;
    private long bulkFlushInterval = -1L;
    private FlushBackoffType bulkFlushBackoffType = FlushBackoffType.NONE;
    private int bulkFlushBackoffRetries = -1;
    private long bulkFlushBackOffDelay = -1L;
    private DeliveryGuarantee deliveryGuarantee = DeliveryGuarantee.AT_LEAST_ONCE;
    private List<HttpHost> hosts;
    protected ElasticsearchEmitter<? super IN> emitter;
    private String username;
    private String password;
    private String connectionPathPrefix;
    private Integer connectionTimeout;
    private Integer connectionRequestTimeout;
    private Integer socketTimeout;

    protected ElasticsearchSinkBuilderBase() {
    }

    protected <S extends ElasticsearchSinkBuilderBase<?, ?>> S self() {
        return (S)this;
    }

    public <T extends IN> ElasticsearchSinkBuilderBase<T, ?> setEmitter(ElasticsearchEmitter<? super T> emitter) {
        Preconditions.checkNotNull(emitter);
        Preconditions.checkState((boolean)InstantiationUtil.isSerializable(emitter), (Object)"The elasticsearch emitter must be serializable.");
        Object self = this.self();
        ((ElasticsearchSinkBuilderBase)self).emitter = emitter;
        return self;
    }

    public B setHosts(HttpHost ... hosts) {
        Preconditions.checkNotNull((Object)hosts);
        Preconditions.checkState((hosts.length > 0 ? 1 : 0) != 0, (Object)"Hosts cannot be empty.");
        this.hosts = Arrays.asList(hosts);
        return (B)this.self();
    }

    public B setDeliveryGuarantee(DeliveryGuarantee deliveryGuarantee) {
        Preconditions.checkState((deliveryGuarantee != DeliveryGuarantee.EXACTLY_ONCE ? 1 : 0) != 0, (Object)"Elasticsearch sink does not support the EXACTLY_ONCE guarantee.");
        this.deliveryGuarantee = (DeliveryGuarantee)((Object)Preconditions.checkNotNull((Object)((Object)deliveryGuarantee)));
        return (B)this.self();
    }

    public B setBulkFlushMaxActions(int numMaxActions) {
        Preconditions.checkState((numMaxActions == -1 || numMaxActions > 0 ? 1 : 0) != 0, (Object)"Max number of buffered actions must be larger than 0.");
        this.bulkFlushMaxActions = numMaxActions;
        return (B)this.self();
    }

    public B setBulkFlushMaxSizeMb(int maxSizeMb) {
        Preconditions.checkState((maxSizeMb == -1 || maxSizeMb > 0 ? 1 : 0) != 0, (Object)"Max size of buffered actions must be larger than 0.");
        this.bulkFlushMaxMb = maxSizeMb;
        return (B)this.self();
    }

    public B setBulkFlushInterval(long intervalMillis) {
        Preconditions.checkState((intervalMillis == -1L || intervalMillis >= 0L ? 1 : 0) != 0, (Object)"Interval (in milliseconds) between each flush must be larger than or equal to 0.");
        this.bulkFlushInterval = intervalMillis;
        return (B)this.self();
    }

    public B setBulkFlushBackoffStrategy(FlushBackoffType flushBackoffType, int maxRetries, long delayMillis) {
        this.bulkFlushBackoffType = (FlushBackoffType)((Object)Preconditions.checkNotNull((Object)((Object)flushBackoffType)));
        Preconditions.checkState((flushBackoffType != FlushBackoffType.NONE ? 1 : 0) != 0, (Object)"FlushBackoffType#NONE does not require a configuration it is the default, retries and delay are ignored.");
        Preconditions.checkState((maxRetries > 0 ? 1 : 0) != 0, (Object)"Max number of backoff attempts must be larger than 0.");
        this.bulkFlushBackoffRetries = maxRetries;
        Preconditions.checkState((delayMillis >= 0L ? 1 : 0) != 0, (Object)"Delay (in milliseconds) between each backoff attempt must be larger than or equal to 0.");
        this.bulkFlushBackOffDelay = delayMillis;
        return (B)this.self();
    }

    public B setConnectionUsername(String username) {
        Preconditions.checkNotNull((Object)username);
        this.username = username;
        return (B)this.self();
    }

    public B setConnectionPassword(String password) {
        Preconditions.checkNotNull((Object)password);
        this.password = password;
        return (B)this.self();
    }

    public B setConnectionPathPrefix(String prefix) {
        Preconditions.checkNotNull((Object)prefix);
        this.connectionPathPrefix = prefix;
        return (B)this.self();
    }

    public B setConnectionRequestTimeout(int timeout) {
        Preconditions.checkState((timeout >= 0 ? 1 : 0) != 0, (Object)"Connection request timeout must be larger than or equal to 0.");
        this.connectionRequestTimeout = timeout;
        return (B)this.self();
    }

    public B setConnectionTimeout(int timeout) {
        Preconditions.checkState((timeout >= 0 ? 1 : 0) != 0, (Object)"Connection timeout must be larger than or equal to 0.");
        this.connectionTimeout = timeout;
        return (B)this.self();
    }

    public B setSocketTimeout(int timeout) {
        Preconditions.checkState((timeout >= 0 ? 1 : 0) != 0, (Object)"Socket timeout must be larger than or equal to 0.");
        this.socketTimeout = timeout;
        return (B)this.self();
    }

    protected abstract BulkProcessorBuilderFactory getBulkProcessorBuilderFactory();

    public ElasticsearchSink<IN> build() {
        Preconditions.checkNotNull(this.emitter);
        Preconditions.checkNotNull(this.hosts);
        NetworkClientConfig networkClientConfig = this.buildNetworkClientConfig();
        BulkProcessorConfig bulkProcessorConfig = this.buildBulkProcessorConfig();
        BulkProcessorBuilderFactory bulkProcessorBuilderFactory = this.getBulkProcessorBuilderFactory();
        ClosureCleaner.clean((Object)bulkProcessorBuilderFactory, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
        return new ElasticsearchSink<IN>(this.hosts, this.emitter, this.deliveryGuarantee, bulkProcessorBuilderFactory, bulkProcessorConfig, networkClientConfig);
    }

    private NetworkClientConfig buildNetworkClientConfig() {
        Preconditions.checkArgument((!this.hosts.isEmpty() ? 1 : 0) != 0, (Object)"Hosts cannot be empty.");
        return new NetworkClientConfig(this.username, this.password, this.connectionPathPrefix, this.connectionRequestTimeout, this.connectionTimeout, this.socketTimeout);
    }

    private BulkProcessorConfig buildBulkProcessorConfig() {
        return new BulkProcessorConfig(this.bulkFlushMaxActions, this.bulkFlushMaxMb, this.bulkFlushInterval, this.bulkFlushBackoffType, this.bulkFlushBackoffRetries, this.bulkFlushBackOffDelay);
    }

    public String toString() {
        return "ElasticsearchSinkBuilder{bulkFlushMaxActions=" + this.bulkFlushMaxActions + ", bulkFlushMaxMb=" + this.bulkFlushMaxMb + ", bulkFlushInterval=" + this.bulkFlushInterval + ", bulkFlushBackoffType=" + (Object)((Object)this.bulkFlushBackoffType) + ", bulkFlushBackoffRetries=" + this.bulkFlushBackoffRetries + ", bulkFlushBackOffDelay=" + this.bulkFlushBackOffDelay + ", deliveryGuarantee=" + (Object)((Object)this.deliveryGuarantee) + ", hosts=" + this.hosts + ", emitter=" + this.emitter + ", username='" + this.username + '\'' + ", password='" + this.password + '\'' + ", connectionPathPrefix='" + this.connectionPathPrefix + '\'' + '}';
    }
}

