/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.suggest.phrase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch6.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.TemplateScript;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.suggest.DirectSpellcheckerSettings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.suggest.SuggestionSearchContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.suggest.phrase.PhraseSuggester;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.suggest.phrase.StupidBackoffScorer;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.suggest.phrase.WordScorer;

class PhraseSuggestionContext
extends SuggestionSearchContext.SuggestionContext {
    static final boolean DEFAULT_COLLATE_PRUNE = false;
    static final boolean DEFAULT_REQUIRE_UNIGRAM = true;
    static final float DEFAULT_CONFIDENCE = 1.0f;
    static final int DEFAULT_GRAM_SIZE = 1;
    static final float DEFAULT_RWE_ERRORLIKELIHOOD = 0.95f;
    static final float DEFAULT_MAX_ERRORS = 0.5f;
    static final String DEFAULT_SEPARATOR = " ";
    static final WordScorer.WordScorerFactory DEFAULT_SCORER = (reader, terms, field, realWordLikelihood, separator) -> new StupidBackoffScorer(reader, terms, field, realWordLikelihood, separator, 0.4f);
    private float maxErrors = 0.5f;
    private BytesRef separator = new BytesRef(" ");
    private float realworldErrorLikelihood = 0.95f;
    private int gramSize = 1;
    private float confidence = 1.0f;
    private int tokenLimit = 10;
    private boolean requireUnigram = true;
    private BytesRef preTag;
    private BytesRef postTag;
    private TemplateScript.Factory scriptFactory;
    private boolean prune = false;
    private List<DirectCandidateGenerator> generators = new ArrayList<DirectCandidateGenerator>();
    private Map<String, Object> collateScriptParams = new HashMap<String, Object>(1);
    private WordScorer.WordScorerFactory scorer = DEFAULT_SCORER;

    PhraseSuggestionContext(QueryShardContext shardContext) {
        super(PhraseSuggester.INSTANCE, shardContext);
    }

    public float maxErrors() {
        return this.maxErrors;
    }

    public void setMaxErrors(Float maxErrors) {
        this.maxErrors = maxErrors.floatValue();
    }

    public BytesRef separator() {
        return this.separator;
    }

    public void setSeparator(BytesRef separator) {
        this.separator = separator;
    }

    public Float realworldErrorLikelihood() {
        return Float.valueOf(this.realworldErrorLikelihood);
    }

    public void setRealWordErrorLikelihood(Float realworldErrorLikelihood) {
        this.realworldErrorLikelihood = realworldErrorLikelihood.floatValue();
    }

    public void addGenerator(DirectCandidateGenerator generator) {
        this.generators.add(generator);
    }

    public List<DirectCandidateGenerator> generators() {
        return this.generators;
    }

    public void setGramSize(int gramSize) {
        this.gramSize = gramSize;
    }

    public int gramSize() {
        return this.gramSize;
    }

    public float confidence() {
        return this.confidence;
    }

    public void setConfidence(float confidence) {
        this.confidence = confidence;
    }

    public void setModel(WordScorer.WordScorerFactory scorer) {
        this.scorer = scorer;
    }

    public WordScorer.WordScorerFactory model() {
        return this.scorer;
    }

    public void setRequireUnigram(boolean requireUnigram) {
        this.requireUnigram = requireUnigram;
    }

    public boolean getRequireUnigram() {
        return this.requireUnigram;
    }

    public void setTokenLimit(int tokenLimit) {
        this.tokenLimit = tokenLimit;
    }

    public int getTokenLimit() {
        return this.tokenLimit;
    }

    public void setPreTag(BytesRef preTag) {
        this.preTag = preTag;
    }

    public BytesRef getPreTag() {
        return this.preTag;
    }

    public void setPostTag(BytesRef postTag) {
        this.postTag = postTag;
    }

    public BytesRef getPostTag() {
        return this.postTag;
    }

    TemplateScript.Factory getCollateQueryScript() {
        return this.scriptFactory;
    }

    void setCollateQueryScript(TemplateScript.Factory scriptFactory) {
        this.scriptFactory = scriptFactory;
    }

    Map<String, Object> getCollateScriptParams() {
        return this.collateScriptParams;
    }

    void setCollateScriptParams(Map<String, Object> collateScriptParams) {
        this.collateScriptParams = new HashMap<String, Object>(collateScriptParams);
    }

    void setCollatePrune(boolean prune) {
        this.prune = prune;
    }

    boolean collatePrune() {
        return this.prune;
    }

    static class DirectCandidateGenerator
    extends DirectSpellcheckerSettings {
        private Analyzer preFilter;
        private Analyzer postFilter;
        private String field;
        private int size = 5;

        DirectCandidateGenerator() {
        }

        public String field() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public int size() {
            return this.size;
        }

        public void size(int size) {
            if (size <= 0) {
                throw new IllegalArgumentException("Size must be positive");
            }
            this.size = size;
        }

        public Analyzer preFilter() {
            return this.preFilter;
        }

        public void preFilter(Analyzer preFilter) {
            this.preFilter = preFilter;
        }

        public Analyzer postFilter() {
            return this.postFilter;
        }

        public void postFilter(Analyzer postFilter) {
            this.postFilter = postFilter;
        }
    }
}

