/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.metrics.tophits;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.Aggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.AggregatorFactories;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.AggregatorFactory;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.metrics.tophits.TopHitsAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.StoredFieldsContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.subphase.DocValueFieldsContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.subphase.ScriptFieldsContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.SearchContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.internal.SubSearchContext;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.search.sort.SortAndFormats;

public class TopHitsAggregatorFactory
extends AggregatorFactory<TopHitsAggregatorFactory> {
    private final int from;
    private final int size;
    private final boolean explain;
    private final boolean version;
    private final boolean seqNoAndPrimaryTerm;
    private final boolean trackScores;
    private final Optional<SortAndFormats> sort;
    private final HighlightBuilder highlightBuilder;
    private final StoredFieldsContext storedFieldsContext;
    private final List<DocValueFieldsContext.FieldAndFormat> docValueFields;
    private final List<ScriptFieldsContext.ScriptField> scriptFields;
    private final FetchSourceContext fetchSourceContext;

    TopHitsAggregatorFactory(String name, int from, int size, boolean explain, boolean version, boolean seqNoAndPrimaryTerm, boolean trackScores, Optional<SortAndFormats> sort, HighlightBuilder highlightBuilder, StoredFieldsContext storedFieldsContext, List<DocValueFieldsContext.FieldAndFormat> docValueFields, List<ScriptFieldsContext.ScriptField> scriptFields, FetchSourceContext fetchSourceContext, SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactories, Map<String, Object> metaData) throws IOException {
        super(name, context, parent, subFactories, metaData);
        this.from = from;
        this.size = size;
        this.explain = explain;
        this.version = version;
        this.seqNoAndPrimaryTerm = seqNoAndPrimaryTerm;
        this.trackScores = trackScores;
        this.sort = sort;
        this.highlightBuilder = highlightBuilder;
        this.storedFieldsContext = storedFieldsContext;
        this.docValueFields = docValueFields;
        this.scriptFields = scriptFields;
        this.fetchSourceContext = fetchSourceContext;
    }

    @Override
    public Aggregator createInternal(Aggregator parent, boolean collectsFromSingleBucket, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) throws IOException {
        SubSearchContext subSearchContext = new SubSearchContext(this.context);
        subSearchContext.parsedQuery(this.context.parsedQuery());
        subSearchContext.explain(this.explain);
        subSearchContext.version(this.version);
        subSearchContext.seqNoAndPrimaryTerm(this.seqNoAndPrimaryTerm);
        subSearchContext.trackScores(this.trackScores);
        subSearchContext.from(this.from);
        subSearchContext.size(this.size);
        if (this.sort.isPresent()) {
            subSearchContext.sort(this.sort.get());
        }
        if (this.storedFieldsContext != null) {
            subSearchContext.storedFieldsContext(this.storedFieldsContext);
        }
        if (this.docValueFields != null) {
            subSearchContext.docValueFieldsContext(new DocValueFieldsContext(this.docValueFields));
        }
        for (ScriptFieldsContext.ScriptField field : this.scriptFields) {
            subSearchContext.scriptFields().add(field);
        }
        if (this.fetchSourceContext != null) {
            subSearchContext.fetchSourceContext(this.fetchSourceContext);
        }
        if (this.highlightBuilder != null) {
            subSearchContext.highlight(this.highlightBuilder.build(this.context.getQueryShardContext()));
        }
        return new TopHitsAggregator(this.context.fetchPhase(), subSearchContext, this.name, this.context, parent, pipelineAggregators, metaData);
    }
}

