/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.mustache;

import java.util.ArrayList;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.MultiSearchRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.MultiSearchResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.SearchRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.TransportMultiSearchAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.ActionFilters;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.support.HandledTransportAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.ScriptService;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.mustache.MultiSearchTemplateRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.mustache.MultiSearchTemplateResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.mustache.SearchTemplateRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.mustache.SearchTemplateResponse;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.mustache.TransportSearchTemplateAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.transport.TransportService;

public class TransportMultiSearchTemplateAction
extends HandledTransportAction<MultiSearchTemplateRequest, MultiSearchTemplateResponse> {
    private final ScriptService scriptService;
    private final NamedXContentRegistry xContentRegistry;
    private final TransportMultiSearchAction multiSearchAction;

    @Inject
    public TransportMultiSearchTemplateAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver resolver, ScriptService scriptService, NamedXContentRegistry xContentRegistry, TransportMultiSearchAction multiSearchAction) {
        super(settings, "indices:data/read/msearch/template", threadPool, transportService, actionFilters, resolver, MultiSearchTemplateRequest::new);
        this.scriptService = scriptService;
        this.xContentRegistry = xContentRegistry;
        this.multiSearchAction = multiSearchAction;
    }

    @Override
    protected void doExecute(MultiSearchTemplateRequest request, ActionListener<MultiSearchTemplateResponse> listener) {
        ArrayList<Integer> originalSlots = new ArrayList<Integer>();
        MultiSearchRequest multiSearchRequest = new MultiSearchRequest();
        multiSearchRequest.indicesOptions(request.indicesOptions());
        if (request.maxConcurrentSearchRequests() != 0) {
            multiSearchRequest.maxConcurrentSearchRequests(request.maxConcurrentSearchRequests());
        }
        MultiSearchTemplateResponse.Item[] items = new MultiSearchTemplateResponse.Item[request.requests().size()];
        for (int i = 0; i < items.length; ++i) {
            SearchRequest searchRequest;
            SearchTemplateRequest searchTemplateRequest = request.requests().get(i);
            SearchTemplateResponse searchTemplateResponse = new SearchTemplateResponse();
            try {
                searchRequest = TransportSearchTemplateAction.convert(searchTemplateRequest, searchTemplateResponse, this.scriptService, this.xContentRegistry);
            }
            catch (Exception e) {
                items[i] = new MultiSearchTemplateResponse.Item(null, e);
                continue;
            }
            items[i] = new MultiSearchTemplateResponse.Item(searchTemplateResponse, null);
            if (searchRequest == null) continue;
            multiSearchRequest.add(searchRequest);
            originalSlots.add(i);
        }
        this.multiSearchAction.execute(multiSearchRequest, ActionListener.wrap(r -> {
            for (int i = 0; i < r.getResponses().length; ++i) {
                MultiSearchResponse.Item item = r.getResponses()[i];
                int originalSlot = (Integer)originalSlots.get(i);
                if (item.isFailure()) {
                    items[originalSlot] = new MultiSearchTemplateResponse.Item(null, item.getFailure());
                    continue;
                }
                items[originalSlot].getResponse().setResponse(item.getResponse());
            }
            listener.onResponse(new MultiSearchTemplateResponse(items));
        }, listener::onFailure));
    }
}

