/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.mustache;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.action.search.SearchRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestChannel;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.RestStatusToXContentListener;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.action.search.RestSearchAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.mustache.SearchTemplateAction;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.script.mustache.SearchTemplateRequest;

public class RestSearchTemplateAction
extends BaseRestHandler {
    private static final Set<String> RESPONSE_PARAMS;

    public RestSearchTemplateAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_search/template", this);
        controller.registerHandler(RestRequest.Method.POST, "/_search/template", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_search/template", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_search/template", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_search/template", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/{type}/_search/template", this);
    }

    @Override
    public String getName() {
        return "search_template_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        SearchTemplateRequest searchTemplateRequest;
        SearchRequest searchRequest = new SearchRequest();
        RestSearchAction.parseSearchRequest(searchRequest, request, null, size -> searchRequest.source().size(size));
        try (XContentParser parser = request.contentOrSourceParamParser();){
            searchTemplateRequest = SearchTemplateRequest.fromXContent(parser);
        }
        searchTemplateRequest.setRequest(searchRequest);
        return channel -> client.execute(SearchTemplateAction.INSTANCE, searchTemplateRequest, new RestStatusToXContentListener((RestChannel)channel));
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    static {
        HashSet<String> responseParams = new HashSet<String>(Arrays.asList("typed_keys", "rest_total_hits_as_int"));
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
    }
}

