/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest;

import java.io.IOException;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Set;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.collect.Tuple;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentHelper;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.apache.flink.elasticsearch6.shaded.org.elasticsearch.rest.RestRequest;

public interface RestRequestFilter {
    default public RestRequest getFilteredRequest(final RestRequest restRequest) throws IOException {
        final Set<String> fields = this.getFilteredFields();
        if (restRequest.hasContent() && !fields.isEmpty()) {
            return new RestRequest(restRequest.getXContentRegistry(), restRequest.params(), restRequest.path(), restRequest.getHeaders()){
                private BytesReference filteredBytes;
                {
                    super(xContentRegistry, params, path, headers);
                    this.filteredBytes = null;
                }

                @Override
                public RestRequest.Method method() {
                    return restRequest.method();
                }

                @Override
                public String uri() {
                    return restRequest.uri();
                }

                @Override
                public boolean hasContent() {
                    return true;
                }

                @Override
                @Nullable
                public SocketAddress getRemoteAddress() {
                    return restRequest.getRemoteAddress();
                }

                @Override
                @Nullable
                public SocketAddress getLocalAddress() {
                    return restRequest.getLocalAddress();
                }

                @Override
                public BytesReference innerContent() {
                    if (this.filteredBytes == null) {
                        BytesReference content = restRequest.content();
                        Tuple<XContentType, Map<String, Object>> result = XContentHelper.convertToMap(content, true);
                        Map<String, Object> transformedSource = XContentMapValues.filter(result.v2(), null, fields.toArray(Strings.EMPTY_ARRAY));
                        try {
                            XContentBuilder xContentBuilder = XContentBuilder.builder(result.v1().xContent()).map(transformedSource);
                            this.filteredBytes = BytesReference.bytes(xContentBuilder);
                        }
                        catch (IOException e) {
                            throw new ElasticsearchException("failed to parse request", (Throwable)e, new Object[0]);
                        }
                    }
                    return this.filteredBytes;
                }
            };
        }
        return restRequest;
    }

    public Set<String> getFilteredFields();
}

